#include "cjppa.h"
#include "cjpp.h"
#ifdef _Macintosh
#include "CyberJackUSBToolbox.h"
#endif // _Macintosh
#include "cjpp.h"

#ifdef _LINUX
#include <string.h>
#include <malloc.h>
#endif /* _LINUX */


//extern int cjppVerifyData(HANDLE cjppDevice,unsigned short addr,unsigned char *Data,unsigned char len);

static void cjppWINAPI ProgressbarThread(ProgressStr *Params)
{
   while(--(Params->CountProgessCallbacks) && !Params->Fini)
   {
      cjppSleep(Params->SleepValue);
      if(!Params->Fini)
         (*(Params->CallbackProgress))(Params->hClass);
   }
}

/*static HANDLE cjppOpen(char *cDeviceName)
{
   char *myName;
   cjppHANDLE hcjppDevice=malloc(sizeof(cjppStruct));
   myName=strdup(cDeviceName);
   strupr(myName);
   if(strstr(myName,"COM")!=NULL)
   {
      Result->cjppStr.is_usb=0;
      Result->cjppStr.reader_id=0;
   }
   else
   {
      Result->cjppStr.is_usb=1;
      Result->cjppStr.reader_id=atoi(cDeviceName+strlen(cDeviceName)-2);
   }
   free(myName);
   memset(hcjppDevice,0,sizeof(cjppStruct));
   cjppFillDevice(hcjppDevice);
   hcjppDevice->hDevice = cjppCreate( cDeviceName);
   if(hcjppDevice->hDevice==0)
   {
      CloseHandle(hcjppDevice->o_transmit.hEvent);
      CloseHandle(hcjppDevice->o_receive.hEvent);
      free(hcjppDevice);
      return (HANDLE)CJPP_ERR_OPENING_DEVICE;
   }
   return (HANDLE)hcjppDevice;
}*/

CJPP_EXP_TYPE int CJPP_CALL_CONV cJppFirmwareUpdate(char *cDeviceName,              /*Geraetenamen: z.B. \\.\cjccid01*/
                       unsigned long Length,           /*Lnge der UpdateDaten*/
                       unsigned char *UpdateData,      /*Daten wie in SGN-Datei*/
                       HANDLE hClass,                  /*this-Pointer der der
                                                         Callbackfunktion
                                                         bergeben wird */
                       void (CJPP_CALLBACK_TYPE *CallbackProgress)(CCID_CTX),
                       int CountProgessCallbacks)      /*Anzahl der gewnschten
                                                         Callbacks*/
{
   int Res;
   cjpp_Info cjppInfo;
   HANDLE hCtDevice;
   HANDLE hCt;
   unsigned short AnzahlSign;
   unsigned short AnzahlSignHelp;
   unsigned long time_needed=0;
   unsigned char *loader;
   unsigned char *appl;
   unsigned short addr;
   ProgressStr Progress;
   HANDLE hThread=NULL;


   AnzahlSign=cjppSWAB_WORD_2(*(unsigned short *)UpdateData);
   UpdateData+=2;
   hCt=ctapiInit(cDeviceName,NULL,NULL,NULL);
   if((int)hCt==0)
      return CJPP_ERR_OPENING_DEVICE;
   hCtDevice = (HANDLE)&(((cjccidHANDLE)hCt)->cjppStr);
	 
	 #ifdef _Macintosh
	 CyberJack_SetIgnoreReadTimeout((DeviceIdentifierRef)((cjppHANDLE)hCtDevice)->hDevice,true);
	 #endif // _Macintosh

   CJPP_TEST3(cjppGetDeviceInfo(hCtDevice,&cjppInfo))
   /*Berechnung der bentigten Zeit*/
   if(cjppInfo.Version>10)
   {
      if(cjppInfo.BootLoaderVersion!=0x0212)
      {
         UpdateData+=(int)AnzahlSign*32770*2;
         AnzahlSign=cjppSWAB_WORD_2(*(unsigned short *)UpdateData);
         UpdateData+=2;
      }
      AnzahlSignHelp=AnzahlSign;
      while(AnzahlSign>1 && cjppSWAB_WORD_2(*(unsigned short *)(UpdateData+32770))<=cjppInfo.LoaderVersion)
      {
         UpdateData+=32770;
         AnzahlSign--;
      }
      loader=UpdateData+2;
      UpdateData+=(int)AnzahlSign*32770;



      if(cjppSWAB_WORD(*(unsigned short *)(loader+0x7e6b))>cjppInfo.LoaderVersion)
      {
    	 if(cjppInfo.LoaderVersion>=0x100e)
            time_needed+=60000;
		 else
            time_needed+=110000;
      }
      else
      {
         loader=NULL;
      }

      AnzahlSign=AnzahlSignHelp;

      while(AnzahlSign>1 && cjppSWAB_WORD_2(*(unsigned short *)(UpdateData+32770))<=cjppInfo.ApplicationVersion)
      {
         UpdateData+=32770;
         AnzahlSign--;
      }
      appl=UpdateData+2;
      if(cjppSWAB_WORD(*(unsigned short *)(appl+0x7e6b))>=cjppInfo.ApplicationVersion || cjppInfo.ApplicationVersion==0xffff)
      {
         time_needed+=35000;
      }
      else
      {
         appl=NULL;
      }
   }
   else
   {
      loader=UpdateData+2;
      UpdateData+=(int)AnzahlSign*32770;
      appl=UpdateData+2;
      time_needed=215000;
   }

   if(loader!=NULL || appl!=NULL)
   {
      if(cjppInfo.ActiveModule==CJPP_APPLICATION)
         time_needed+=5000;
      if(CallbackProgress!=NULL)
      {
         Progress.SleepValue=time_needed/CountProgessCallbacks;
         Progress.CallbackProgress=CallbackProgress;
         Progress.hClass=hClass;
         Progress.CountProgessCallbacks=CountProgessCallbacks;
         Progress.Fini=0;
         hThread=cjppCreateThread((void (*)(void *))ProgressbarThread,&Progress);
      }

      if(cjppInfo.ActiveModule==CJPP_APPLICATION)
      {
				CJPP_TEST2(cjppStartLoader(hCtDevice))
				cjppSleep(6000);
				ctapiClose(hCt);
				#ifdef __MACH__
				CyberJack_TerminateFramework();
				CyberJack_InitFramework();
				#endif // __MACH__
				hCt=ctapiInit(cDeviceName,NULL,NULL,NULL);
				if((int)hCt==0)
					return CJPP_ERR_OPENING_DEVICE;
				hCtDevice = (HANDLE)&(((cjccidHANDLE)hCt)->cjppStr);
				if((int)hCtDevice==CJPP_ERR_OPENING_DEVICE)
				{
					Progress.Fini=1;
					cjppSleep(1000);
					cjppTerminateThread(hThread);
					return CJPP_ERR_OPENING_DEVICE;
				}
				#ifdef _Macintosh
				CyberJack_SetIgnoreReadTimeout((DeviceIdentifierRef)((cjppHANDLE)hCtDevice)->hDevice,true);
				#endif // _Macintosh
      }
      if(loader)
      {
         loader+=8;
         CJPP_TEST2(cjppUpdateData(hCtDevice,8,loader,56))
         loader+=56;
         CJPP_TEST2(cjppUpdateData(hCtDevice,64,loader,64))
         loader+=64;
         CJPP_TEST2(cjppUpdateData(hCtDevice,128,loader,64))
         loader+=64;
         CJPP_TEST2(cjppUpdateData(hCtDevice,192,loader,64))
         loader+=64+0x500;
         for(addr=0x0600;addr<0x7f00;addr+=(unsigned short)64,loader+=64)
            CJPP_TEST2(cjppUpdateData(hCtDevice,addr,loader,64))
         CJPP_TEST2(cjppVerifyUpdate(hCtDevice))
         cjppSleep(8000);
         ctapiClose(hCt);
				 #ifdef __MACH__
				 CyberJack_TerminateFramework();
				 CyberJack_InitFramework();
				 #endif // __MACH__
      }
      if(appl)
      {
         if(loader)
         {
						hCt=ctapiInit(cDeviceName,NULL,NULL,NULL);
						if((int)hCt==0)
							return CJPP_ERR_OPENING_DEVICE;
						hCtDevice = (HANDLE)&(((cjccidHANDLE)hCt)->cjppStr);
            if((int)hCtDevice==CJPP_ERR_OPENING_DEVICE)
            {
               Progress.Fini=1;
               cjppSleep(1000);
               cjppTerminateThread(hThread);
               return CJPP_ERR_OPENING_DEVICE;
            }
						#ifdef _Macintosh
						CyberJack_SetIgnoreReadTimeout((DeviceIdentifierRef)((cjppHANDLE)hCtDevice)->hDevice,true);
						#endif // _Macintosh
         }
         appl+=8;
         CJPP_TEST2(cjppUpdateData(hCtDevice,8,appl,56))
         appl+=56;
         CJPP_TEST2(cjppUpdateData(hCtDevice,64,appl,64))
         appl+=64;
         CJPP_TEST2(cjppUpdateData(hCtDevice,128,appl,64))
         appl+=64;
         CJPP_TEST2(cjppUpdateData(hCtDevice,192,appl,64))
         appl+=64+0x500;
   //      for(addr=0;addr<0x7f00;addr+=(unsigned short)64,appl+=64)
   //         CJPP_TEST2(cjppUpdateData(hCtDevice,addr,appl,64))
   //      cjppUpdateData(hCtDevice,0x7ffd,"\x40",1);
         for(addr=0x600;addr<0x7f00;addr+=(unsigned short)64,appl+=64)
            CJPP_TEST2(cjppUpdateData(hCtDevice,addr,appl,64))
         appl+=8;
         CJPP_TEST2(cjppVerifyUpdate(hCtDevice))
         cjppSleep(5000);
      }
      if(CallbackProgress!=NULL)
      {
         Progress.Fini=1;
         cjppSleep(1000);
         cjppTerminateThread(hThread);
//         while(--(Progress.CountProgessCallbacks))
//            (*(Progress.CallbackProgress))(Progress.hClass);
      }
      ctapiClose(hCt);
			#ifdef __MACH__
			CyberJack_TerminateFramework();
			CyberJack_InitFramework();
			#endif // __MACH__
      return CJPP_SUCCESS;
   }
   else
   {
      ctapiClose(hCt);
			#ifdef __MACH__
			CyberJack_TerminateFramework();
			CyberJack_InitFramework();
			#endif // __MACH__
      return CJPP_ERR_FIRMWARE_OLD;
   }
}

int cjppWriteAndRead(HANDLE cjppDevice,CCID_Message *Message,CCID_Response *Response)
{
   Message->dwLength=cjppSWAB_DWORD_2(Message->dwLength);
   Message->bSeq=((cjppHANDLE)cjppDevice)->bSeq++;
   CJPP_TEST(cjppTransfer(cjppDevice,Message,Response))
   Response->dwLength=cjppSWAB_DWORD_2(Response->dwLength);
   if(Message->bSeq!=Response->bSeq) {
      DEBUGP("Message-bSeq=0x%08x, Response->bSeq=0x%08x\n",
	     Message->bSeq, Response->bSeq);
      return CJPP_ERR_SEQ;
   }
   switch(Message->bMessageType)
   {
      case PC_TO_RDR_ICCPOWERON:
      case PC_TO_RDR_XFRBLOCK:
      case PC_TO_RDR_SECURE:
        if(Response->bMessageType!=RDR_TO_PC_DATABLOCK)
           return CJPP_ERR_WRONG_ANSWER;
        break;
      case PC_TO_RDR_ICCPOWEROFF:
      case PC_TO_RDR_GETSLOTSTATUS:
      case PC_TO_RDR_TAPDU:
      case PC_TO_RDR_MECHANICAL:
      case PC_TO_RDR_ABORT:
        if(Response->bMessageType!=RDR_TO_PC_SLOTSTATUS)
           return CJPP_ERR_WRONG_ANSWER;
        break;
      case PC_TO_RDR_GETPARAMETERS:
      case PC_TO_RDR_RESETPARAMETERS:
      case PC_TO_RDR_SETPARAMETERS:
        if(Response->bMessageType!=RDR_TO_PC_PARAMETERS)
           return CJPP_ERR_WRONG_ANSWER;
        break;
      case PC_TO_RDR_ESCAPE:
        if(Response->bMessageType!=RDR_TO_PC_ESCAPE)
           return CJPP_ERR_WRONG_ANSWER;
        break;
      case PC_TO_RDR_ICCCLOCK:
        if(Response->bMessageType!=RDR_TO_PC_STATUSCLOCK)
           return CJPP_ERR_WRONG_ANSWER;
        break;
      case PC_TO_RDR_SETDATARATEANDCLOCKFREQUENCY:
        if(Response->bMessageType!=RDR_TO_PC_DATARATEANDCLOCKFREQUENCY)
           return CJPP_ERR_WRONG_ANSWER;
        break;
      default:
        return CJPP_ERR_WRONG_ANSWER;
   }
   return CJPP_SUCCESS;
}

int cjppGetDeviceInfo(HANDLE cjppDevice,cjpp_Info *cjppInfo)
{
	CCID_Message Message;
	CCID_Response Response;

   Message.bMessageType=PC_TO_RDR_ESCAPE;
   Message.dwLength=1;
   Message.bSlot=0;
   Message.Data.Escape.bFunction=CCID_ESCAPE_GET_INFO;

   CJPP_TEST(cjppWriteAndRead(cjppDevice,&Message,&Response))
   if(Response.dwLength!=sizeof(cjpp_Info) && Response.dwLength!=18) {
   	DEBUGP("Response.dwLength=%u, cjpp_Info=%u\n", 
		Response.dwLength, sizeof(cjpp_Info));
      return CJPP_ERR_WRONG_LENGTH;
   }
   memcpy(cjppInfo,Response.Data.abData,sizeof(cjpp_Info));
   cjppInfo->Version=cjppSWAB_WORD(cjppInfo->Version);
   cjppInfo->LoaderVersion=cjppSWAB_WORD(cjppInfo->LoaderVersion);
   cjppInfo->ApplicationVersion=cjppSWAB_WORD(cjppInfo->ApplicationVersion);
   cjppInfo->BootLoaderVersion=cjppSWAB_WORD(cjppInfo->BootLoaderVersion);
   return CJPP_SUCCESS;
}

int cjppStartLoader(HANDLE cjppDevice)
{
	CCID_Message Message;
	CCID_Response Response;

   Message.bMessageType=PC_TO_RDR_ESCAPE;
   Message.dwLength=1;
   Message.bSlot=0;
   Message.Data.Escape.bFunction=CCID_ESCAPE_UPDATE_START;

   CJPP_TEST(cjppWriteAndRead(cjppDevice,&Message,&Response))
   if(Response.dwLength!=0)
      return CJPP_ERR_WRONG_LENGTH;

   return CJPP_SUCCESS;
}

int cjppUpdateData(HANDLE cjppDevice,unsigned short addr,unsigned char *Data,unsigned char len)
{
	CCID_Message Message;
	CCID_Response Response;

   Message.bMessageType=PC_TO_RDR_ESCAPE;
   Message.dwLength=4+len;
   Message.bSlot=0;
   Message.Data.Escape.bFunction=CCID_ESCAPE_UPDATE;
   Message.Data.Escape.Data.Update.wOffset=cjppSWAB_WORD(addr);
   Message.Data.Escape.Data.Update.bLength=len;
   memcpy(Message.Data.Escape.Data.Update.Data,Data,len);
   CJPP_TEST(cjppWriteAndRead(cjppDevice,&Message,&Response))
   if(Response.dwLength!=0)
      return CJPP_ERR_WRONG_LENGTH;
   if(Response.bError!=0)
      return CJPP_ERR_WRONG_SIZE;
   return CJPP_SUCCESS;
}

/*int cjppVerifyData(HANDLE cjppDevice,unsigned short addr,unsigned char *Data,unsigned char len)
{
	CCID_Message Message;
	CCID_Response Response;

   Message.bMessageType=PC_TO_RDR_ESCAPE;
   Message.dwLength=4+len;
   Message.bSlot=0;
   Message.Data.Escape.bFunction=CCID_ESCAPE_VERIFYDATA;
   Message.Data.Escape.Data.Update.wOffset=cjppSWAB_WORD(addr);
   Message.Data.Escape.Data.Update.bLength=len;
   memcpy(Message.Data.Escape.Data.Update.Data,Data,len);
   CJPP_TEST(cjppWriteAndRead(cjppDevice,&Message,&Response))
   if(Response.bError==3)
      return CJPP_SUCCESS;
   if(Response.bError!=0)
      return CJPP_ERR_WRONG_SIZE;
   if(Response.dwLength!=0)
      return CJPP_ERR_WRONG_LENGTH;
   return CJPP_SUCCESS;
}*/

int cjppVerifyUpdate(HANDLE cjppDevice)
{
	CCID_Message Message;
	CCID_Response Response;

   Message.bMessageType=PC_TO_RDR_ESCAPE;
   Message.dwLength=1;
   Message.bSlot=0;
   Message.Data.Escape.bFunction=CCID_ESCAPE_VERIFY;
   CJPP_TEST(cjppWriteAndRead(cjppDevice,&Message,&Response))
   if(Response.dwLength!=0)
      return CJPP_ERR_WRONG_LENGTH;
   if(Response.bError!=0)
      return CJPP_ERR_SIGN;
   return CJPP_SUCCESS;
}

int cjppInput(HANDLE cjppDevice,unsigned char *key,unsigned char timeout)
{
	CCID_Message Message;
	CCID_Response Response;

   Message.bMessageType=PC_TO_RDR_ESCAPE;
   Message.dwLength=2;
   Message.bSlot=0;
   Message.Data.Escape.bFunction=CCID_ESCAPE_INPUT;
   Message.Data.Escape.Data.Input.Timeout=timeout;
   CJPP_TEST(cjppWriteAndRead(cjppDevice,&Message,&Response))
   if(Response.dwLength!=1)
      return CJPP_ERR_WRONG_LENGTH;
   *key=Response.Data.abData[0];

   return CJPP_SUCCESS;
}





