
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>

#include "cjppa.h"

#define CT_API_AD_CT		1
#define CT_API_AD_ICC1		0
#define CT_API_AD_ICC2		2
#define CT_API_AD_ICC3		3
#define CT_API_AD_ICC4		4
#define CT_API_AD_ICC5		5
#define CT_API_AD_ICC6		6
#define CT_API_AD_ICC7		7
#define CT_API_AD_ICC8		8
#define CT_API_AD_ICC9		9
#define CT_API_AD_ICC10		10
#define CT_API_AD_ICC11		11
#define CT_API_AD_ICC12		12
#define CT_API_AD_ICC13		13
#define CT_API_AD_ICC14		14

#define CT_API_RV_OK		0
#define CT_API_RV_ERR_INVALID	-1
#define CT_API_RV_ERR_CT	-8
#define CT_API_RV_ERR_TRANS	-10
#define CT_API_RV_ERR_MEMORY	-11
#define CT_API_RV_ERR_HOST	-127
#define CT_API_RV_ERR_HTSI	-128

#define SENDCMD(dadv,cmdv,cmdlenv) \
	memcpy( cmd, cmdv, cmdlenv ); \
	lenc=cmdlenv; lenr=sizeof(rsp); sad=2; dad=dadv; \
	ret = ctapiData( dev, &dad, &sad, lenc, cmd, &lenr, rsp ); \
	if( ret!=CT_API_RV_OK ) goto err_return;

static int read_geldkarte(CCID_DEVICE dev)
{
	u_int8_t cmd[5+255+1], rsp[256+2];
	u_int8_t sad, dad;
	u_int16_t lenc, lenr=256+2;
	int8_t ret;

	/* Reset ICC */
	//SENDCMD( CT_API_AD_CT, "\x20\x11\x01\x01\x00", 5 );
	//SENDCMD( CT_API_AD_CT, "\x20\x12\x01\x01\x00", 5 );
	SENDCMD( CT_API_AD_CT, "\x20\x12\x01\x01\x03\x80\x01\x10\x00", 9 );
	if( (ret!=CT_API_RV_OK) || (sad!=CT_API_AD_CT) ) {
		printf( "Error sending command to reader. (Return code:%d)\n", ret );
		SENDCMD( CT_API_AD_CT, "\x20\x15\x01\x00", 5 );
		sleep(2);
		return 3;
	}

	if( lenr==24+2 ) {
		/* Geldkarte v2? */
		if( memcmp( rsp+7, "\x45\x65\x63", 3 ) ) {
			printf( "Unknown card.\n");
			goto err_icccmd;
		}

		/* Select AID */
		SENDCMD( CT_API_AD_ICC1, "\x00\xA4\x04\x0C\x09\xD2\x76\x00\x00\x25\x45\x50\x01\x00", 14 );
		if( sad!=CT_API_AD_ICC1 ) goto err_sad;
		if( (lenr!=2) || (rsp[0]!=0x90) || (rsp[1]!=0x00) ) {
			printf("Error selecting GeldKarte application.\n");
			goto err_icccmd;
		}

		/* Read Record */
		SENDCMD( CT_API_AD_ICC1, "\x00\xB2\x01\xC4\x09", 5 );
		if( sad!=CT_API_AD_ICC1 ) goto err_sad;
		if( (lenr<5) || (rsp[lenr-2]!=0x90) || (rsp[lenr-1]!=0x00) ) {
			printf("Error reading account balance.\n");
			goto err_icccmd;
		}
	} else if( lenr==25+2 ) {
		/* Geldkarte v3? */
		if( memcmp( rsp+8, "\x45\x65\x63", 3 ) ) {
			printf( "Unknown card.\n");
			goto err_icccmd;
		}

		/* Select AID */
		SENDCMD( CT_API_AD_ICC1, "\x00\xA4\x04\x0C\x09\xD2\x76\x00\x00\x25\x45\x50\x02\x00", 14 );
		if( sad!=CT_API_AD_ICC1 ) goto err_sad;
		if( (lenr!=2) || (rsp[0]!=0x90) || (rsp[1]!=0x00) ) {
			printf("Error selecting GeldKarte application.\n");
			goto err_icccmd;
		}

		/* Read Record */
		SENDCMD( CT_API_AD_ICC1, "\x00\xB2\x01\xC4\x00", 5 );
		if( sad!=CT_API_AD_ICC1 ) goto err_sad;
		if( (lenr<5) || (rsp[lenr-2]!=0x90) || (rsp[lenr-1]!=0x00) ) {
			printf("Error reading account balance.\n");
			goto err_icccmd;
		}
	} else if( (lenr>2) && (rsp[lenr-2]==0x90) ) {
		printf( "Unknown card.\n" );
		goto err_icccmd;
	} else {
		printf( "No card.\n" );
		sleep(2);
		return 0;
	}

	printf("Current account balance: %.2X%.2X.%.2X\n", rsp[0], rsp[1], rsp[2] );

err_icccmd:
	SENDCMD( CT_API_AD_CT, "\x20\x15\x01\x00", 5 );
		sleep(2);
	return 0;

err_return:
	printf( "Error sending command to card. (Return code:%d)\n", ret );
		sleep(2);
	return 3;
err_sad:
	printf( "Error sending command to card. (sad:%d)\n", sad );
		sleep(2);
	return 3;
}

#if 0
int test_ctapi(CCID_DEVICE dev, int pn )
{
	IU8 cmd[5+255+1], rsp[256+2];
	IU8 sad, dad;
	IU16 ctn=1;
	IU16 lenc, lenr=256+2;
	IS8 ret;

	int i;

	/* Open */
	ret = CT_init( ctn, pn );
	if( ret!=CT_API_RV_OK ) {
		printf("Error doing CT_init. (Return code:%d)\n",ret);
		return 3;
	}

	for (i = 0; i < 5; i++) {
		ret = read_geldkarte(ctn);
		if (ret) {
			CT_close(ctn);
			return ret;
		}
	}

	CT_close(ctn);
}
#endif 


void CJPP_CALLBACK_TYPE status_cb(CCID_CTX ctx, unsigned char status)
{

}

void CJPP_CALLBACK_TYPE key_cb(CCID_CTX ctx, unsigned char status)
{

}

int main(int argc, char **argv)
{
	CCID_DEVICE dev;
	dev = ctapiInit("/dev/foo", NULL, status_cb, key_cb);

	if (!dev)
		fprintf(stderr, "error\n");

	read_geldkarte(dev);
	ctapiClose(dev);

	exit(0);
}
