#include "cjppa.h"
#include "cjpp.h"

#include <string.h>

#define SELECT            0xA4
#define READBINARY        0xB0
#define UPDATEBINARY      0xD6
#define VERIFY            0x20
#define MODIFY            0x24
#define DIRECT            0x60
#define GETKEYSTATUS      0xF2

static unsigned short TestSID(unsigned char *capdu,int capdu_len,unsigned char *rapdu,unsigned short *rapdu_len,unsigned short ID)
{
   unsigned short Result=0x6700;
   if(capdu_len>6)
   {
      if(capdu[4]==2)
      {
         if(capdu[5]==(unsigned char)(ID>>8) && capdu[6]==(unsigned char)ID)
            Result=0x9000;
         else
            Result=0x6a82;
      }
   }
   *rapdu_len=2;
	*rapdu++=(unsigned char)(Result>>8);
	*rapdu=(unsigned char)(Result);
   return Result;
}

static int S10SyncCommands(HANDLE hDevice,unsigned char Command,unsigned char addr,unsigned char outlen,unsigned char *outdata,int len,unsigned char *indata)
{
	int Result;
	unsigned char sbuffer[261];
	int rlen;
	sbuffer[0]=Command;
	sbuffer[1]=addr;
	sbuffer[2]=outlen;
	sbuffer[3]=(unsigned char)(len>>8);
	sbuffer[4]=(unsigned char)len;
	if(outlen>0)
   	   memcpy(sbuffer+5,outdata,outlen);
	rlen=len;
   if((Result=cjccid_XfrBlock(hDevice,0,sbuffer,5+outlen,indata,&rlen,0))!=CJPP_SUCCESS)
   {
      cjccid_iccPowerOff(hDevice);
   }
   return Result;
}

static int S9SyncCommands(HANDLE hDevice,unsigned char Command,unsigned short addr,unsigned char outlen,unsigned char *outdata,int len,unsigned char *indata)
{
	int Result;
	unsigned char sbuffer[261];
	int rlen;
	sbuffer[0]=(unsigned char)(addr>>8);
	sbuffer[1]=(unsigned char)addr;
	sbuffer[2]=outlen;
	sbuffer[3]=(unsigned char)(len>>8);
	sbuffer[4]=(unsigned char)len;
	if(outlen>0)
   	   memcpy(sbuffer+5,outdata,outlen);
	rlen=len;
   if((Result=cjccid_XfrBlock(hDevice,Command,sbuffer,5+outlen,indata,&rlen,0))!=CJPP_SUCCESS)
   {
      cjccid_iccPowerOff(hDevice);
   }
   return Result;
}

static int S8SyncCommand(HANDLE hDevice,unsigned short offset,unsigned short outlen,unsigned char *out,unsigned short inlen,unsigned char *in)
{
   unsigned char buffer[260];
   unsigned char addr;
   int Result;
   int rlen;

   addr=((cjccidHANDLE)hDevice)->iic_deviceaddr;
   if(((cjccidHANDLE)hDevice)->iic_offset_bytes==1)
   {
	   addr|=((offset>>7) & 0x0e);
	   buffer[1]=(unsigned char)offset;
	   memcpy(buffer+2,out,outlen);
	   outlen+=2;
   }
   else
   {
	   buffer[1]=(unsigned char)(offset>>8);
	   buffer[2]=(unsigned char)offset;
	   memcpy(buffer+3,out,outlen);
	   outlen+=3;
   }
   buffer[0]=addr;
   rlen=inlen;

   
   if((Result=cjccid_XfrBlock(hDevice,0,buffer,outlen,in,&rlen,(unsigned short)rlen))!=CJPP_SUCCESS)
   {
      cjccid_iccPowerOff(hDevice);
   }
   return Result;
}


int SyncInterpreter(HANDLE hDevice,unsigned short lenc,unsigned char *cmd,unsigned short *lenr,unsigned char *response)
{
	int Res;
   unsigned char command;
   unsigned char buffer[260];
   unsigned short Rest;
   unsigned short len;
   unsigned char Offset;
   unsigned char *ptr;
   unsigned char *ptr2;
   unsigned short glen;
	unsigned char cbyte;
   unsigned short Result=0x6700;
   unsigned short addr=(((unsigned short)cmd[2])<<8)+cmd[3];

   switch(((cjccidHANDLE)hDevice)->Protokoll)
   {
      case 8:
		   if(cmd[0]!=0 && (cmd[0]!=0x80 || cmd[1]!=GETKEYSTATUS))
			{
			   response[0]=0x6E;
			   response[1]=0x00;
			   *lenr=2;
			   return CJPP_SUCCESS;
			}
		   switch(cmd[1])
			{
            case SELECT:
               if((Result=TestSID(cmd,lenc,response,lenr,0x3F00))==0x9000)
                  ((cjccidHANDLE)hDevice)->IFSC=0;
               response[0]=(unsigned char)(Result>>8);
               response[1]=(unsigned char)Result;
               *lenr=2;
               break;
            case READBINARY:
					
					len=cmd[4];
					if(len==0)
						len=256;
    				if(len+2>*lenr)
					{
						*lenr=0;
						return CJPP_ERR_RBUFFER_TO_SMALL;
					}
					CJPP_TEST(S8SyncCommand(hDevice,(unsigned short)((((unsigned short)cmd[2])<<8)+cmd[3]),0,0,len,response));
               *lenr=len+2;
               response[len]=0x90;
               response[len+1]=0;
					break;
            case UPDATEBINARY:
					if(lenc!=5+cmd[4])
					{
                  response[0]=0x67;
                  response[1]=0;
                  *lenr=2;
      			   return CJPP_SUCCESS;
					}
               len=cmd[4];
               ptr=cmd+5;
               Result=0x9000;
					addr=(unsigned short)((((unsigned short)cmd[2])<<8)+cmd[3]);
               while(len)
               {
                  Rest=((cjccidHANDLE)hDevice)->iic_pagesize-(addr%((cjccidHANDLE)hDevice)->iic_pagesize);
                  Rest=(Rest>len)?len:Rest;
                  if(S8SyncCommand(hDevice,addr,Rest,ptr,0,0)!=CJPP_SUCCESS)
                  {
                     Result=0x6F00;
                     break;
                  }
                  addr+=Rest;
                  len-=Rest;
                  ptr+=Rest;
               }
               response[0]=(unsigned char)(Result>>8);
               response[1]=(unsigned char)Result;
               *lenr=2;
            break;
		  
            default:
               response[0]=0x6d;
               response[1]=0;
               *lenr=2;
			}
			break;
      case 9:
		   if(cmd[0]!=0 && (cmd[0]!=0x80 || cmd[1]!=GETKEYSTATUS))
			{
			   response[0]=0x6E;
			   response[1]=0x00;
			   *lenr=2;
			   return CJPP_SUCCESS;
			}
			if(cmd[2]>3)
			{
			   response[0]=0x6A;
			   response[1]=0x00;
			   *lenr=2;
			   return CJPP_SUCCESS;
			}
		   switch(cmd[1])
			{
            case SELECT:
               if((Result=TestSID(cmd,lenc,response,lenr,0x3F00))==0x9000)
                  ((cjccidHANDLE)hDevice)->IFSC=0;
               else if((Result=TestSID(cmd,lenc,response,lenr,0x2F09))==0x9000)
                  ((cjccidHANDLE)hDevice)->IFSC=1;
               response[0]=(unsigned char)(Result>>8);
               response[1]=(unsigned char)Result;
               *lenr=2;
               break;
            case READBINARY:
					if(((cjccidHANDLE)hDevice)->IFSC==0)
					{
						len=cmd[4];
						if(len==0)
							len=256;
    					if(len+2>*lenr)
						{
							*lenr=0;
							return CJPP_ERR_RBUFFER_TO_SMALL;
						}
						CJPP_TEST(S9SyncCommands(hDevice,0x0e,(unsigned short)((((unsigned short)cmd[2])<<8)+cmd[3]),0,0,len,response));
					}
               else
					{
						len=cmd[4];
						if(len==0)
							len=256;
    					if(len+2>*lenr)
						{
							*lenr=0;
							return CJPP_ERR_RBUFFER_TO_SMALL;
						}
						glen=len>>3;
						if((len&7)!=0)
							glen++;
						CJPP_TEST(S9SyncCommands(hDevice,0x0c,(unsigned short)((((unsigned short)cmd[2])<<8)+cmd[3]),0,0,glen,buffer));
						ptr=response;
						memset(ptr,0,len);
						Rest=len;
						for(command=0;command<glen;command++)
						{
							for(Res=0;Res<8;Res++)
							{
   							if(buffer[command] & 1)
	   							*ptr=0x01;
		   					ptr++;
							   buffer[command] >>= 1;
								if(--Rest==0)
									break;
							}
						}
					}
               *lenr=len+2;
               response[len]=0x90;
               response[len+1]=0;
               break;
            case UPDATEBINARY:
					if(((cjccidHANDLE)hDevice)->IFSC==0)
                  command=0x33;
               else
                  command=0x30;
               CJPP_TEST(S9SyncCommands(hDevice,command,(unsigned short)((((unsigned short)cmd[2])<<8)+cmd[3]),cmd[4],cmd+5,0,0));
					if(((cjccidHANDLE)hDevice)->IFSC==0)
					{
                  CJPP_TEST(S9SyncCommands(hDevice,0x0e,(unsigned short)((((unsigned short)cmd[2])<<8)+cmd[3]),0,0,cmd[4],buffer));
						if(memcmp(buffer,cmd+5,cmd[4])!=0)
						{
							response[0]=0x65;
							response[1]=0x81;
							*lenr=2;
							return CJPP_SUCCESS;
						}
					}
               response[0]=0x90;
               response[1]=0;
               *lenr=2;
               break;
            case VERIFY:
            case MODIFY:
               if((lenc==7 && cmd[4]==2) ||
                  (lenc==9 && cmd[4]==4))
               {
                  ptr=cmd+5;
                  if(cmd[1]==VERIFY || lenc==9)
                  {
                     CJPP_TEST(S9SyncCommands(hDevice,0x0e,1021,0,0,1,buffer));
                     if((addr=buffer[0])==0)
                        Result=0x6983;
                     else
                     {
                        for(Offset=1;(addr & (Offset ^ 0xff))==addr;Offset<<=1);
                        addr&= (Offset ^ 0xff);
								cbyte=(unsigned char)addr;
                        CJPP_TEST(S9SyncCommands(hDevice,0x32,1021,1,&cbyte,0,0));
                        CJPP_TEST(S9SyncCommands(hDevice,0x0d,1022,2,ptr,0,0));
								ptr+=2;
								cbyte=0xff;
                        CJPP_TEST(S9SyncCommands(hDevice,0x33,1021,1,&cbyte,0,0));
                        CJPP_TEST(S9SyncCommands(hDevice,0x0e,1021,0,0,1,buffer));
                        if((Offset=buffer[0])!=0xff)
                        {
                           len=0;
                           for(addr=0;addr<8;addr++)
                           {
                              if(Offset&1)
                                 len++;
                              Offset>>=1;
                           }
                           Result=(((unsigned short)len)) | 0x63c0;
                        }
                     }
                  }
                  if(Result==0x6700)
                  {
                     if(cmd[1]==VERIFY)
                     {
                        Result=0x9000;
                     }
                     else
                     {
                        ptr2=ptr;
								cbyte=0xff;
                        CJPP_TEST(S9SyncCommands(hDevice,0x33,1021,1,&cbyte,0,0));
                        CJPP_TEST(S9SyncCommands(hDevice,0x33,1022,2,ptr,0,0));
   							ptr+=2;
                        CJPP_TEST(S9SyncCommands(hDevice,0x0e,1021,0,0,1,buffer));
                        if((Offset=buffer[0])!=0xff)
                        {
                           len=0;
                           for(addr=0;addr<8;addr++)
                           {
                              if(Offset&1)
                                 len++;
                              Offset>>=1;
                           }
                           Result=((unsigned short)len) | 0x63C0;
                        }
                        else
                        {
                           Result=0x9000;
                        }
                     }
                  }
                  memset(buffer,0,1);
               }
               response[0]=(unsigned char)(Result>>8);
               response[1]=(unsigned char)Result;
               *lenr=2;
               break;
				case GETKEYSTATUS:
               CJPP_TEST(S9SyncCommands(hDevice,0x0e,1021,0,0,1,buffer));
					Offset=buffer[0];
               len=0;
               for(addr=0;addr<8;addr++)
               {
                  if(Offset&1)
                     len++;
                  Offset>>=1;
               }
               response[0]=(unsigned char)len;
               response[1]=0x90;
               response[2]=0x00;
               *lenr=3;
					break;


            default:
               response[0]=0x6d;
               response[1]=0;
               *lenr=2;
         }
         break;
      case 10:
		   if(cmd[0]!=0 && (cmd[0]!=0x80 || cmd[1]!=GETKEYSTATUS))
			{
			   response[0]=0x6E;
			   response[1]=0x00;
			   *lenr=2;
			   return CJPP_SUCCESS;
			}
			if(cmd[2]!=0)
			{
			   response[0]=0x6A;
			   response[1]=0x00;
			   *lenr=2;
			   return CJPP_SUCCESS;
			}
		   switch(cmd[1])
			{
            case SELECT:
               if((Result=TestSID(cmd,lenc,response,lenr,0x3F00))==0x9000)
                  ((cjccidHANDLE)hDevice)->IFSC=0;
               else if((Result=TestSID(cmd,lenc,response,lenr,0x2F09))==0x9000)
                  ((cjccidHANDLE)hDevice)->IFSC=1;
               response[0]=(unsigned char)(Result>>8);
               response[1]=(unsigned char)Result;
               *lenr=2;
               break;
            case READBINARY:
					if(((cjccidHANDLE)hDevice)->IFSC==0)
					{
						len=cmd[4];
						if(len==0)
							len=256;
    					if(len+2>*lenr)
						{
							*lenr=0;
							return CJPP_ERR_RBUFFER_TO_SMALL;
						}
						CJPP_TEST(S10SyncCommands(hDevice,0x30,cmd[3],0,0,len,response));
					}
               else
					{
						if(cmd[2]!=0 || cmd[3]>31 || cmd[3]+cmd[4]>32)
						{
							response[0]=0x6A;
							response[1]=0x00;
							*lenr=2;
							return CJPP_SUCCESS;
						}
						len=cmd[4];
						if(len==0)
							len=32;
						if(len>32-cmd[3])
							len=32;
    					if(len+2>*lenr)
						{
							*lenr=0;
							return CJPP_ERR_RBUFFER_TO_SMALL;
						}
						CJPP_TEST(S10SyncCommands(hDevice,0x34,0,0,0,4,buffer));
						ptr=buffer+4;
						memset(ptr,0,32);
						for(command=0;command<4;command++)
						{
							for(Res=0;Res<8;Res++)
							{
   							if(buffer[command] & 1)
	   							*ptr=0x01;
		   					ptr++;
							   buffer[command] >>= 1;
							}
						}
						memcpy(response,buffer+4+cmd[3],len);
					}
               *lenr=len+2;
               response[len]=0x90;
               response[len+1]=0;
               break;
            case UPDATEBINARY:
					if(((cjccidHANDLE)hDevice)->IFSC==0)
                  command=0x38;
               else
                  command=0x3c;
               CJPP_TEST(S10SyncCommands(hDevice,command,cmd[3],cmd[4],cmd+5,0,0));
					if(((cjccidHANDLE)hDevice)->IFSC==0)
					{
                  CJPP_TEST(S10SyncCommands(hDevice,0x30,cmd[3],0,0,cmd[4],buffer));
						if(memcmp(buffer,cmd+5,cmd[4])!=0)
						{
							response[0]=0x65;
							response[1]=0x81;
							*lenr=2;
							return CJPP_SUCCESS;
						}
					}
               response[0]=0x90;
               response[1]=0;
               *lenr=2;
               break;
            case VERIFY:
            case MODIFY:
               if((lenc==8 && cmd[4]==3) ||
                  (lenc==11 && cmd[4]==6))
               {
                  ptr=cmd+5;
                  if(cmd[1]==VERIFY || lenc==11)
                  {
                     CJPP_TEST(S10SyncCommands(hDevice,0x31,0xff,0,0,4,buffer));
                     if((addr=buffer[0])==0)
                        Result=0x6983;
                     else
                     {
                        for(Offset=1;(addr & (Offset ^ 0xff))==addr;Offset<<=1);
                        addr&= (Offset ^ 0xff);
								cbyte=(unsigned char)addr;
                        CJPP_TEST(S10SyncCommands(hDevice,0x39,0,1,&cbyte,0,0));
                        CJPP_TEST(S10SyncCommands(hDevice,0x33,1,3,ptr,0,0));
								ptr+=3;
								cbyte=7;
                        CJPP_TEST(S10SyncCommands(hDevice,0x39,0,1,&cbyte,0,0));
                        CJPP_TEST(S10SyncCommands(hDevice,0x31,0xff,0,0,4,buffer));
                        if((Offset=buffer[0])!=7)
                        {
                           len=0;
                           for(addr=0;addr<8;addr++)
                           {
                              if(Offset&1)
                                 len++;
                              Offset>>=1;
                           }
                           Result=(((unsigned short)len)) | 0x63c0;
                        }
                     }
                  }
                  if(Result==0x6700)
                  {
                     if(cmd[1]==VERIFY)
                     {
                        Result=0x9000;
                     }
                     else
                     {
                        ptr2=ptr;
								cbyte=7;
                        CJPP_TEST(S10SyncCommands(hDevice,0x39,0,1,&cbyte,0,0));
                        CJPP_TEST(S10SyncCommands(hDevice,0x39,1,3,ptr,0,0));
   							ptr+=3;
                        CJPP_TEST(S10SyncCommands(hDevice,0x31,0xff,0,0,4,buffer));
                        if((Offset=buffer[0])!=7)
                        {
                           len=0;
                           for(addr=0;addr<8;addr++)
                           {
                              if(Offset&1)
                                 len++;
                              Offset>>=1;
                           }
                           Result=((unsigned short)len) | 0x63C0;
                        }
                        else
                        {
                           Result=0x9000;
                        }
                     }
                  }
                  memset(buffer,0,4);
               }
               response[0]=(unsigned char)(Result>>8);
               response[1]=(unsigned char)Result;
               *lenr=2;
               break;
				case GETKEYSTATUS:
               CJPP_TEST(S10SyncCommands(hDevice,0x31,0xff,0,0,4,buffer));
               len=0;
					Offset=buffer[0];
               for(addr=0;addr<8;addr++)
               {
                  if(Offset&1)
                     len++;
                  Offset>>=1;
               }
               response[0]=(unsigned char)len;
               response[1]=0x90;
               response[2]=0x00;
               *lenr=3;
					break;


            default:
               response[0]=0x6d;
               response[1]=0;
               *lenr=2;
         }
         break;
      default:
         response[0]=0x6f;
         response[1]=0;
         *lenr=2;
   }
	return CJPP_SUCCESS;
}
