#include "cjppa.h"
#include "cjpp.h"

#include <malloc.h>
#include <stdio.h>
#include <time.h>


extern char *DebugOut;


typedef struct
{
	char		m_aText[512];
	char		m_aSource[32];
	INT			m_nData1;
	INT			m_nData2;
	INT			m_nData3;
	INT			m_nData4;
	INT			m_nTime;

} CWinMsg;

void cjppDebugCommand(CCID_DEVICE hDevice,unsigned char *dad,unsigned char *sad,unsigned short lenc,unsigned char *cmd,unsigned short *lenr,unsigned char *response)
{
   if(DebugOut!=NULL)
   {
      HWND pcWin;
      if(*DebugOut!='\0')
      {
         FILE *stream=fopen(DebugOut,"at");
         if(stream!=NULL)
         {
            int i=0;
            unsigned char *ptr=cmd;
            clock_t cl=clock();

            fprintf(stream,"PC -> CYBJCK: %6d,%#03d --- LEN: %5d --- SAD: %2d --- DAD: %2d\nData:   ",
                    cl/1000,cl%1000,(int)lenc,(int)*sad,(int)*dad);
            for(i=0;i<lenc;i++)
            {
               if((i%16)==0 && i+1<lenc)
               {
                  fprintf(stream,"\n        ");
               }
               fprintf(stream,"%02X ",(int)*ptr++);
            }
            fprintf(stream,"\n\n");
            fclose(stream);
         }
      }
	   pcWin=FindWindow (NULL,"SiiDebugMon2");
      if(pcWin)
      {
         int i=0;
         unsigned char *ptr=cmd;
         DWORD cl=GetTickCount();
         ULONG			nBytesToCopy=0;
         COPYDATASTRUCT	cds;
         CWinMsg		 	botschaft;
         memset(&botschaft,0,sizeof(botschaft));
         sprintf(botschaft.m_aText,"PC -> CYBJCK: LEN: %5d --- SAD: %2d --- DAD: %2d\n",
                 (int)lenc,(int)*sad,(int)*dad);
         botschaft.m_aText[sizeof (botschaft.m_aText)-1]=0x00;
         botschaft.m_nTime=cl;
         sprintf(botschaft.m_aSource,"CJPPA_LOW_%#02d",(int)(((cjccidHANDLE)hDevice)->cjppStr.reader_id));
         cds.dwData = 0;
         cds.cbData = sizeof (botschaft);
         cds.lpData = &botschaft;
         SendMessage (pcWin,WM_COPYDATA,0, (LPARAM) &cds);
         strcpy(botschaft.m_aText,"        DATA: ");
         for(i=0;i<lenc;i++)
         {
            sprintf(botschaft.m_aText+14+(i%16)*3,"%02X ",(int)*ptr++);
            if((i%16)==15)
            {
               strcat(botschaft.m_aText,"\n");
               SendMessage (pcWin,WM_COPYDATA,0, (LPARAM) &cds);
               strcpy(botschaft.m_aText,"              ");
            }
         }
         if((lenc%16)!=0)
         {
            strcat(botschaft.m_aText,"\n");
            SendMessage (pcWin,WM_COPYDATA,0, (LPARAM) &cds);
         }
      }
   }
}

void cjppDebugResponse(CCID_DEVICE hDevice,unsigned char *dad,unsigned char *sad,unsigned short lenc,unsigned char *cmd,unsigned short *lenr,unsigned char *response,char res)
{
   if(DebugOut!=NULL)
   {
      HWND pcWin;
      if(*DebugOut!='\0')
      {
         FILE *stream=fopen(DebugOut,"at");
         if(stream!=NULL)
         {
            int i=0;
            unsigned char *ptr=response;
            clock_t cl=clock();

            fprintf(stream,"CYBJCK -> PC: %6d,%#03d --- LEN: %5d --- SAD: %2d --- DAD: %2d Result: %3d\nData:   ",
                    cl/1000,cl%1000,(int)*lenr,(int)*sad,(int)*dad,(int)res);
            if(res==0)
            {
               for(i=0;i<*lenr;i++)
               {
                  if((i%16)==0 && i+1<*lenr)
                  {
                     fprintf(stream,"\n        ");
                  }
                  fprintf(stream,"%02X ",(int)*ptr++);
               }
            }
            fprintf(stream,"\n\n");
            fclose(stream);
         }
      }
	   pcWin=FindWindow (NULL,"SiiDebugMon2");
      if(pcWin)
      {
         int i=0;
         unsigned char *ptr=response;
         DWORD cl=GetTickCount();
         ULONG			nBytesToCopy=0;
         COPYDATASTRUCT	cds;
         CWinMsg		 	botschaft;
         memset(&botschaft,0,sizeof(botschaft));
         sprintf(botschaft.m_aText,"CYBJCK -> PC: LEN: %5d --- SAD: %2d --- DAD: %2d Result: %3d\n",
                 (int)*lenr,(int)*sad,(int)*dad,(int)res);
         botschaft.m_aText[sizeof (botschaft.m_aText)-1]=0x00;
         botschaft.m_nTime=cl;
         sprintf(botschaft.m_aSource,"CJPPA_LOW_%#02d",(int)(((cjccidHANDLE)hDevice)->cjppStr.reader_id));
         cds.dwData = 0;
         cds.cbData = sizeof (botschaft);
         cds.lpData = &botschaft;
         SendMessage (pcWin,WM_COPYDATA,0, (LPARAM) &cds);
         if(res==0)
         {
            strcpy(botschaft.m_aText,"        DATA: ");
            for(i=0;i<*lenr;i++)
            {
               sprintf(botschaft.m_aText+14+(i%16)*3,"%02X ",(int)*ptr++);
               if((i%16)==15)
               {
                  strcat(botschaft.m_aText,"\n");
                  SendMessage (pcWin,WM_COPYDATA,0, (LPARAM) &cds);
                  strcpy(botschaft.m_aText,"              ");
               }
            }
            if((*lenr%16)!=0)
            {
               strcat(botschaft.m_aText,"\n");
               SendMessage (pcWin,WM_COPYDATA,0, (LPARAM) &cds);
            }
         }
      }
   }
}


void cjppDebugOut(cjppHANDLE hDevice,unsigned char *Caption,unsigned short lenc,unsigned char *cmd)
{
   if(DebugOut!=NULL)
   {
      HWND pcWin;
	   pcWin=FindWindow (NULL,"SiiDebugMon2");
      if(pcWin)
      {
         int i=0;
         unsigned char *ptr=cmd;
         DWORD cl=GetTickCount();
         ULONG			nBytesToCopy=0;
         COPYDATASTRUCT	cds;
         CWinMsg		 	botschaft;
         memset(&botschaft,0,sizeof(botschaft));
         sprintf(botschaft.m_aText,"%s\n",Caption);
         botschaft.m_aText[sizeof (botschaft.m_aText)-1]=0x00;
         botschaft.m_nTime=cl;
         sprintf(botschaft.m_aSource,"CJPPA_DOUT_%#02d",(int)(hDevice->reader_id));
         cds.dwData = 0;
         cds.cbData = sizeof (botschaft);
         cds.lpData = &botschaft;
         SendMessage (pcWin,WM_COPYDATA,0, (LPARAM) &cds);
         strcpy(botschaft.m_aText,"        DATA: ");
         for(i=0;i<lenc;i++)
         {
            sprintf(botschaft.m_aText+14+(i%16)*3,"%02X ",(int)*ptr++);
            if((i%16)==15)
            {
               strcat(botschaft.m_aText,"\n");
               SendMessage (pcWin,WM_COPYDATA,0, (LPARAM) &cds);
               strcpy(botschaft.m_aText,"              ");
            }
         }
         if((lenc%16)!=0)
         {
            strcat(botschaft.m_aText,"\n");
            SendMessage (pcWin,WM_COPYDATA,0, (LPARAM) &cds);
         }
		}
   }
}
