/***************************************************************************
 * CT-API library for the REINER SCT cyberJack pinpad/e-com USB.
 * Copyright (C) 2001  REINER SCT
 * Author: Matthias Bruestle
 * Support: linux-usb@sii.li
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * File: cjpin.c
 * CVS: $Id:$
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <ctapi.h>

#ifndef CT
#define CT 1
#endif
#ifndef HOST
#define HOST 2
#endif

#define CMD_MULTIFLEX	"\x00\xA4\x00\x00\x02\x3F\x00"
#define LEN_MULTIFLEX	7

#define CMD_MEB1		"\x00\xA4\x01\x0C\x02\x01\x00"
#define LEN_MEB1		7

#define CMD_MEB2		"\x00\xA4\x03\x00\x00"
#define LEN_MEB2		4

#define CMD_SIM1		"\xA0\x20\x00\x01\x08\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF"
#define LEN_SIM1		13

#define CMD_INPUT_SIM1	"\x20\x18\x01\x00\x11\x52\x0F\x41\x06\xA0\x20\x00\x01\x08\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\x00"
#define LEN_INPUT_SIM1	22

#define CMD_INPUT_SIM2	"\x20\x18\x01\x00\x14\x52\x0F\x41\x06\xA0\x20\x00\x01\x08\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\x80\x01\x20"
#define LEN_INPUT_SIM2	25

#define CMD_INPUT_CFW1	"\x20\x18\x01\x00\x11\x52\x0F\x81\x06\xC0\x20\x00\x01\x08\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\x00"
#define LEN_INPUT_CFW1	22

#define CMD_INPUT_CFW2	"\x20\x18\x01\x00\x14\x52\x0F\x81\x06\xC0\x20\x00\x01\x08\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\x80\x01\x90"
#define LEN_INPUT_CFW2	25

int main( int argc, char *argv[] )
{
	unsigned char dad, sad, rsp[258];
	unsigned short ctn=0, lr;
	char ret;
	int i;

	/* Initialise CT-API library */
	ret = CT_init( ctn, 1 );
	printf( "CT_init: %d\n", ret );
	if( ret!=CT_API_RV_OK ) return( 1 );

	/* RESET CT */
	dad = CT;
	sad = HOST;
	lr = sizeof( rsp );
	ret = CT_data( ctn, &dad, &sad, 4, (unsigned char*)"\x20\x11\x00\x00",
		&lr, rsp );
	printf( "CT_data: %d\n", ret );
	if( ret!=CT_API_RV_OK ) return( 1 );
	printf( "    sad: %d, dad: %d, rsp:", sad, dad );
	for( i=0; i<lr; i++ ) printf( " %.2X", rsp[i] );
	printf( "\n" );

	/* GET STATUS */
	dad = CT;
	sad = HOST;
	lr = sizeof( rsp );
	ret = CT_data( ctn, &dad, &sad, 5, (unsigned char*)"\x20\x13\x00\x80\x00",
		&lr, rsp );
	printf( "CT_data: %d\n", ret );
	if( ret!=CT_API_RV_OK ) return( 1 );
	printf( "    sad: %d, dad: %d, rsp:", sad, dad );
	for( i=0; i<lr; i++ ) printf( " %.2X", rsp[i] );
	printf( "\n" );

	/* REQUEST ICC (timeout 20s) */
	dad = CT;
	sad = HOST;
	lr = sizeof( rsp );
	ret = CT_data( ctn, &dad, &sad, 7, (unsigned char*)
		"\x20\x12\x01\x01\x01\x14\x00", &lr, rsp );
	printf( "CT_data: %d\n", ret );
	if( ret!=CT_API_RV_OK ) return( 1 );
	printf( "    sad: %d, dad: %d, rsp:", sad, dad );
	for( i=0; i<lr; i++ ) printf( " %.2X", rsp[i] );
	printf( "\n" );

#if 0
	/* Send a command */
	printf ("MEB1\n");
	dad = 0;
	sad = HOST;
	lr = sizeof( rsp );
	ret = CT_data( ctn, &dad, &sad, LEN_MEB1, (unsigned char*)
		CMD_MEB1, &lr, rsp );
	printf( "CT_data: %d\n", ret );
	if( ret!=CT_API_RV_OK ) return( 1 );
	printf( "    sad: %d, dad: %d, rsp:", sad, dad );
	for( i=0; i<lr; i++ ) printf( " %.2X", rsp[i] );
	printf( "\n" );

	/* Send a command */
	printf ("MEB2\n");
	dad = 0;
	sad = HOST;
	lr = sizeof( rsp );
	ret = CT_data( ctn, &dad, &sad, LEN_MEB2, (unsigned char*)
		CMD_MEB2, &lr, rsp );
	printf( "CT_data: %d\n", ret );
	if( ret!=CT_API_RV_OK ) return( 1 );
	printf( "    sad: %d, dad: %d, rsp:", sad, dad );
	for( i=0; i<lr; i++ ) printf( " %.2X", rsp[i] );
	printf( "\n" );
#endif

	/* Send an INPUT command */
	printf ("CFW1\n");
	dad = CT;
	sad = HOST;
	lr = sizeof( rsp );
	ret = CT_data( ctn, &dad, &sad, LEN_INPUT_CFW1, (unsigned char*)
		CMD_INPUT_CFW1, &lr, rsp );
	printf( "CT_data: %d\n", ret );
	if( ret!=CT_API_RV_OK ) return( 1 );
	printf( "    sad: %d, dad: %d, rsp:", sad, dad );
	for( i=0; i<lr; i++ ) printf( " %.2X", rsp[i] );
	printf( "\n" );

	/* EJECT ICC (power down card) */
	dad = CT;
	sad = HOST;
	lr = sizeof( rsp );
	ret = CT_data( ctn, &dad, &sad, 4, (unsigned char*)"\x20\x15\x01\x00",
		&lr, rsp );
	printf( "CT_data: %d\n", ret );
	if( ret!=CT_API_RV_OK ) return( 1 );
	printf( "    sad: %d, dad: %d, rsp:", sad, dad );
	for( i=0; i<lr; i++ ) printf( " %.2X", rsp[i] );
	printf( "\n" );

	/* Shutdown library */
	ret = CT_close( ctn );
	printf( "CT_close: %d\n", ret );
	if( ret!=CT_API_RV_OK ) return( 1 );

	return( 0 );
}

