#
# spec file for package ctapi-cyberjack (Version 1.0.0)
# 

%define	_realrelease	1

Name:		ctapi-cyberjack
Summary:	CT-API 1.1 driver for REINER SCT cyberjack USB chipcard reader
Version:	2.0.6
%if "%{_vendor}" == "suse"
Release:	%{_realrelease}_suse%{suse_version}
BuildRequires:	libusb, readline-devel, ncurses-devel
%else
%if "%{_vendor}" == "redhat"
Release:	%{_realrelease}_redhat%{redhat_version}
BuildRequires:	libusb-devel, readline-devel
%else
BuildRequires:	libusb-devel, readline-devel
Release:	%{_realrelease+_%{_vendor}unknown
%endif
%endif
License: 	LGPL
Group: 		Development/Libraries
Source: 	%{name}-%{version}.tar.bz2
Patch0:		ctapi-cyberjack-2.0.4-rh73_old_libusb.patch
Buildroot: 	%{_tmppath}/ctapi-cyberjack-%{version}-%{release}-root
Requires:	libusb, hotplug

#%define prefix 		/usr
#%define lib_dir		%{prefix}/lib
%define readers_dir	%{_libdir}/readers

%package devel
Summary:	Development files for libctapi-cyberjack
Requires:	%{name} = %{version}
Group:		Development/Libraries

%description
REINER SCT cyberJack pinpad/e-com USB user space driver

This package includes the CT-API driver for the cyberJack pinpad/e-com
USB chipcard reader.

This package changes the permissions of /dev/ttyUSB devices 0-3 to
2666. This gives the users the possibility to access the devices and
enables mandatory locking.

The kernel side driver is included in the official linux kernel starting
with version 2.4.6.

For more information regarding installation under Linux see the README.txt
in the documentation directory, esp. regarding compatibility with host
controllers.

For more information about the reader, software updates and a shop see
http://www.reiner-sct.com/

%description devel
Development files for libctapi-cyberjack

%prep
%setup -q -n %{name}-%{version}
%if "%{_vendor}" == "redhat" 
%if "%{redhat_version}" == "73"
%patch0  -p1 
%endif
%endif

%build
make

%install
if [ -n "%{buildroot}" ] ; then
   [ "%{buildroot}" != "/" ] && rm -rf %{buildroot}
fi
# CT-API
mkdir -p %{buildroot}/%{readers_dir}
install -m 755 ctapi/libctapi-cyberjack.so %{buildroot}/%{readers_dir}/libctapi-cyberjack.so.%{version}
install -m 755 ctapi/libctapi-cyberjack.a %{buildroot}/%{readers_dir}/libctapi-cyberjack.a
( cd %{buildroot}/%{readers_dir}; ln -s libctapi-cyberjack.so.%{version} libctapi-cyberjack.so )
( cd %{buildroot}/%{readers_dir}; ln -s libctapi-cyberjack.so libctapi.so )
( cd %{buildroot}/%{_libdir}; ln -s %{readers_dir}/libctapi.so libctapi.so )
( cd %{buildroot}/%{_libdir}; ln -s %{readers_dir}/libctapi-cyberjack.a libctapi-cyberjack.a )
mkdir -p %{buildroot}/%{_includedir}
install -m 644 ctapi/include/ctapi.h %{buildroot}/%{_includedir}/ctapi.h
mkdir -p %{buildroot}/%{_bindir}
install -m 755 tools/cjgeldkarte %{buildroot}/%{_bindir}/cjgeldkarte
mkdir -p %{buildroot}/%{_sysconfdir}/hotplug/usb
install -m 755 etc/hotplug/usbcyberjack %{buildroot}/%{_sysconfdir}/hotplug/usb/usbcyberjack
install etc/hotplug/cyberjack.usermap %{buildroot}/%{_sysconfdir}/hotplug/usb/cyberjack.usermap
install -m 755 tools/ctsh %{buildroot}/%{_bindir}/ctsh
# PC/SC
#mkdir -p %{buildroot}/%{readers_dir}
install -m 755 pcsc/libcyberjack_ifd.so %{buildroot}/%{readers_dir}/libcyberjack_ifd.so.%{version}
( cd %{buildroot}/%{readers_dir}; ln -s libcyberjack_ifd.so.%{version} libcyberjack_ifd.so )
mkdir -p %{buildroot}%{_sysconfdir}
install -m 644 etc/reader.conf %{buildroot}%{_sysconfdir}/reader.conf.cyberjack

%pre
groupadd -r cyberjack 2>/dev/null || :

%post
if [ ! -e /etc/reader.conf ] ; then
   cp /etc/reader.conf.cyberjack /etc/reader.conf
fi
if [ -e /dev/ttyUSB0 ] ; then
   chmod 2666 /dev/ttyUSB0
else
   mknod -m 2666 /dev/ttyUSB0 c 188 0
fi
if [ -e /dev/ttyUSB1 ] ; then
   chmod 2666 /dev/ttyUSB1
else
   mknod -m 2666 /dev/ttyUSB1 c 188 1
fi
if [ -e /dev/ttyUSB2 ] ; then
   chmod 2666 /dev/ttyUSB2
else
   mknod -m 2666 /dev/ttyUSB2 c 188 2
fi
if [ -e /dev/ttyUSB3 ] ; then
   chmod 2666 /dev/ttyUSB3
else
   mknod -m 2666 /dev/ttyUSB3 c 188 3
fi

%clean
if [ -n "%{buildroot}" ] ; then
   [ "%{buildroot}" != "/" ] && rm -rf %{buildroot}
fi

%files
%defattr(0644,root,root)
%doc COPYRIGHT.GPL COPYRIGHT.LGPL doc/README.pdf doc/README.html doc/README.txt MAKEUSBDEV tools/ctshrc.example
%attr(0755,root,root) %{_sysconfdir}/hotplug/usb/usbcyberjack
%{_sysconfdir}/hotplug/usb/cyberjack.usermap
# CT-API
%{readers_dir}/libctapi-cyberjack.so.%{version}
%{readers_dir}/libctapi-cyberjack.so
%{readers_dir}/libctapi.so
%{_libdir}/libctapi.so
%attr(0755,root,root) %{_bindir}/cjgeldkarte
%attr(0755,root,root) %{prefix}/bin/ctsh
# PC/SC
/%{readers_dir}/libcyberjack_ifd.so.%{version}
/%{readers_dir}/libcyberjack_ifd.so
%{_sysconfdir}/reader.conf.cyberjack

%files devel
%defattr(0644,root,root)
%{_includedir}/ctapi.h
%{readers_dir}/libctapi-cyberjack.a
%{_libdir}/libctapi-cyberjack.a

%changelog -n ctapi-cyberjack
* Sun Dec 19 2004 - Harald Welte <hwelte@hmw-consulting.de>
+ ctapi-cyberjack-2.0.5-1
- add functionality to beep at keypress
- introduce CJCTAPI_NO_KEYBEEP environment variable

* Wed Nov 17 2004 - Harald Welte <hwelte@hmw-consulting.de>
+ ctapi-cyberjack-2.0.4-2
- add x86_64 -fPIC patch for pcsc
- add x86_64 64bit data type patch

* Tue Nov 16 2004 - Harald Welte <hwelte@hmw-consulting.de>
+ ctapi-cyberjack-2.0.4-1
- fixes: gcc-2.95 compile, cjgeldkarte-getopt, SIGSEGV / ctapiClose

* Tue Nov 02 2004 - Harald Welte <hwelte@hmw-consulting.de>
+ ctapi-cyberjack-2.0.2-1
- fix libusb linking dependency

* Wed Aug 25 2004 - Harald Welte <hwelte@hmw-consulting.de>
+ ctapi-cyberjack-2.0.1-1
- Bugfixes in REINER-SCT driver for pinpad_a

* Fri Aug 13 2004 - Harald Welte <hwelte@hmw-consulting.de>
+ ctapi-cyberjack-2.0.0-0beta1
- final new usb ProductID (0x300) for pp_a
- Include build of pcsc library
- Include ctsh
- Include static library into -devel

* Wed Aug 11 2004 - Harald Welte <hwelte@hmw-consulting.de>
+ ctapi-cyberjack-2.0.0-0beta
- Update to new major release including pinpad_a support
- New dual driver shared library architecture

* Tue Mar 18 2003 - Matthias Bruestle <m@mbsks.franken.de>
- Devices are created, when not present.

* Sun May 03 2002 - Matthias Bruestle <m@mbsks.franken.de>
- Added ctsh.

* Fri Dec 21 2001 - Matthias Bruestle <m@mbsks.franken.de>
- Added cjgeldkarte.

* Fri Dec 14 2001 - Matthias Bruestle <m@mbsks.franken.de>
- Added some polish.

* Sat Dec 01 2001 - Matthias Bruestle <m@mbsks.franken.de>
- Added PC/SC IFD handler.

* Sun Aug 26 2001 - mge@suse.de
- adopted package to SuSE build system

* Sun Jun 03 2001 - Matthias Bruestle <m@mbsks.franken.de
- First version of the SPEC file.
