#define WANT_CJDEBUG 1
#include "cjppa.h"
#include "cjpp.h"

#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include "ausb/ausb.h"
#include <netinet/in.h>

#include "cjppa_linux.h"

#ifdef CJPPA_DEBUG
#include <stdio.h>
#define debug_out(x, args...)	fprintf(stderr, x, ## args)
#else
#define debug_out(x, args...)
#endif


cjccidHANDLE AllHandles[512];


/* Linux specific internal functions */

static struct usb_device *find_cj_usbdev(char *name)
{
	struct usb_bus *busses, *bus;
	struct usb_device *dev;

	busses = usb_get_busses();

	/* FIXME: this ignores topology changes after first device was opened */
	for (bus = busses; bus; bus = bus->next) {
		for (dev = bus->devices; dev; dev = dev->next) {
			if (!strcmp(dev->filename, name))
				return dev;
		}
	}
	return NULL;
}



/* These functions must be implemented for different Platforms*/

#if 0
static int cjppWaitInt(HANDLE hDevice,CCID_Interrupt *Intr,int *Fini)
{
/*
   HANDLE Ev;
   unsigned char *buffer;
   OVERLAPPED *over;
   DWORD *nRet;
   buffer=malloc(270);
   over=malloc(sizeof(OVERLAPPED));
   nRet=malloc(sizeof(DWORD));


   memset(over,0,sizeof(over));
   Ev=over->hEvent=CreateEvent(NULL,FALSE,FALSE,NULL);
   for(*nRet=0;*nRet==0 && !(*Fini);)
   {
      *nRet=0;
      ResetEvent(over->hEvent);
      over->Offset=0;
      over->OffsetHigh=0;
      memcpy(buffer,"CJCC",4);
      if(!DeviceIoControl(hDevice,IOCTL_CCID_INT,NULL,0,buffer,270,nRet,over))
      {
         if(GetLastError()!=ERROR_IO_PENDING)
         {
           CloseHandle(over->hEvent);
           free(buffer);
           free(over);
           free(nRet);
           return CJPP_ERR_DEVICE_LOST;
         }
         GetOverlappedResult(hDevice,over,nRet,TRUE);
      }
   }
   memcpy(Intr,buffer,sizeof(CCID_Interrupt));
   CloseHandle(over->hEvent);
   free(buffer);
   free(over);
   free(nRet);
   return CJPP_SUCCESS;
*/
	debug_out("### cjppWaitInt - not implemented!\n");
	return CJPP_ERR_DEVICE_LOST;
}
#endif


static void handle_interrupt(struct usbdevfs_urb *uurb, void *userdata)
{
	ausb_dev_handle *ah;
	cjccidHANDLE hDevice = userdata;

	if (!uurb) {
		debug_out("received interrupt with no urb?!?\n");
		return;
	}

	ausb_dump_urb(uurb);

#if 0
	if (uurb->actual_length < sizeof(CCID_Interrupt)) {
		debug_out("received short interrupt packet (%u bytes)\n",
			  uurb->actual_length);
		return;
	}
#endif

	ah = uurb->usercontext;

	if (!hDevice)
		debug_out("cannot dispatch interrupt event: missing context\n");
	else	
		HandleCyberJackInterruptData(hDevice, 
					     (CCID_Interrupt*)uurb->buffer);

	/* we have to resubmit interrupt */
	if (ausb_submit_urb(ah, uurb))
		debug_out("unable to resubmit interrupt urb\n");

	return;
}

int cjppLinux_SetInterruptEventNotificationProc(cjccidHANDLE cjccid, ausb_dev_handle *ah)
{
	struct usbdevfs_urb *uurb = malloc(sizeof(*uurb));
	char *buffer = malloc(280);

	debug_out("%s entered\n", __FUNCTION__);

	if (!uurb || !buffer) {
		debug_out("unable to allocate urb\n");
		return -1;
	}

	if (ausb_register_callback(ah, USBDEVFS_URB_TYPE_INTERRUPT, 
				   handle_interrupt, cjccid)) {
		debug_out("unable to register interrupt callback\n");
		return -1;
	}

	ausb_fill_int_urb(uurb, 0x81, buffer, sizeof(buffer));
	if (ausb_submit_urb(ah, uurb)) {
		debug_out("unable to submit interrupt urb\n");
		return -1;
	}

	return 0;
}

HANDLE cjppCreate(char *cDeviceName)
{
	struct usb_device *dev;
	ausb_dev_handle *hdl;

	if (getenv("CJDEBUG"))
		cjppDebugSetLevel(1);
	
	ausb_init();

	dev = find_cj_usbdev(cDeviceName);
	if (!dev) {
		debug_out("unable to find cyberjack usb device\n");
		return NULL;
	}

	hdl = ausb_open(dev);
	if (!hdl) {
		debug_out("unable to open usb device: %s\n", strerror(errno));
		return NULL;
	}

#if 1
	if (ausb_set_configuration(hdl, 1)) {
		debug_out("unable to set usb configuration\n");
		return NULL;
	}
#endif

	if (ausb_claim_interface(hdl, 0)) {
		debug_out("unable to claim usb device\n");
		return NULL;
	}

	return (HANDLE) hdl;
}


unsigned long cjppGetLocalInfo(void)
{
	/* FIXME */
	return 0xffffffff;
}

void cjppFillDevice(cjppHANDLE hcjppDevice)
{
   /* FIXME */
}

#if 0
static void cjppClose(HANDLE cjppDevice)
{
	usb_dev_handle *hdl;
	struct usb_device *dev;

	hdl = (usb_dev_handle *) ((cjppHANDLE)cjppDevice)->hDevice;
	dev = usb_device(hdl);

	if (!dev) {
		debug_out("unable to resovle device for handle %p\n", hdl);
		return;
	}
	
	usb_release_interface(hdl, 0);
	usb_close(dev);

	free(cjppDevice);
}
#endif

void cjccidClose(HANDLE cjppDevice)
{
	ausb_dev_handle *hdl;

	hdl = (ausb_dev_handle *) ((cjppHANDLE)cjppDevice)->hDevice;

	ausb_release_interface(hdl, 0);
	ausb_close(hdl);

	/* cjccidClose frees the handle, so we don't */
}

unsigned short cjppSWAB_WORD(unsigned short Value)
{
	return htons(Value);
}

unsigned long cjppSWAB_DWORD(unsigned long Value)
{
	return htonl(Value);
}

static unsigned short cjppSWAP_ALWAYS(unsigned short Value)
{
	unsigned char b;
	b = (unsigned char)(Value>>8);
	Value <<= 8;
	return (unsigned short)(Value+b);
}

unsigned short cjppSWAB_WORD_2(unsigned short Value)
{
	Value = htons(Value);
	return cjppSWAP_ALWAYS(Value);
}
unsigned long cjppSWAB_DWORD_2(unsigned long Value)
{
	unsigned short w;
	Value = htonl(Value);
	w = cjppSWAP_ALWAYS((unsigned short)(Value>>16));
	Value = cjppSWAP_ALWAYS((unsigned short)Value);
	Value <<= 16;
	return Value+w;
}

void cjppSleep(unsigned long Value)
{
	usleep(Value*1000);
}

int cjppRead(HANDLE cjppDevice,CCID_Response *Response)
{
	u_int32_t	bytesRead;

	memset(Response, 0, sizeof(*Response));
	
	bytesRead = 0;
	while (bytesRead == 0 || memcmp(Response,"\x00\x00\x00\x00", 4) == 0) {
		debug_out("reading from bulk in pipe\n");
		bytesRead = ausb_bulk_read((ausb_dev_handle *)((cjppHANDLE)cjppDevice)->hDevice, 0x85, (char *)Response, sizeof(CCID_Response), USB_READ_TIMEOUT);
		if ( bytesRead == 0 ) {
			debug_out("%s: returning ERR_DEVICE_LOST\n", 
				  __FUNCTION__);
			return CJPP_ERR_DEVICE_LOST;
	//return CJPP_SUCCESS;
		}
	}
	debug_out("%s: returning SUCCESS (%u bytes)\n", __FUNCTION__, 
		  bytesRead);
	return CJPP_SUCCESS;
}


int cjppWrite(HANDLE cjppDevice,CCID_Message *Message)
{
	unsigned char	buffer[274];
	u_int32_t	bytesToWrite, bytesWritten;

	memcpy(buffer,Message,270);
	
	bytesToWrite = 10+cjppSWAB_DWORD_2(Message->dwLength);
	debug_out("%s: writing %u bytes to bulk out pipe:", __FUNCTION__,
		  bytesToWrite);
	bytesWritten = ausb_bulk_write((ausb_dev_handle *)((cjppHANDLE)cjppDevice)->hDevice, 0x04, buffer, bytesToWrite, USB_WRITE_TIMEOUT);
	if ( bytesWritten < bytesToWrite ) {
		debug_out("%s: wrote only %u of %u bytes\n", __FUNCTION__,
			  bytesWritten, bytesToWrite);
		debug_out("%s: returning ERR_WRITE_DEVICE\n", __FUNCTION__);
		return CJPP_ERR_WRITE_DEVICE;
	}

	debug_out("%s: returning SUCCESS\n", __FUNCTION__);
	return CJPP_SUCCESS;
}

int cjppTransfer(HANDLE cjppDevice, CCID_Message *Message,
		 CCID_Response *Response)
{
#ifdef CJPPA_DEBUG_TRANSFER
	int Res;
	unsigned char dad, sad;
	unsigned short lenc = 20+cjppSWAB_DWORD_2(Message->dwLength);
	unsigned char *cmd = (unsigned char *) Message;
	unsigned short lenr = sizeof(CCID_Response);
	unsigned char *response = (unsigned char *) Response;

	cjppDebugCommand(NULL, &sad, &dad, lenc, cmd, &lenr, response);
#endif
	CJPP_TEST(cjppWrite(cjppDevice,Message))
	CJPP_TEST(cjppRead(cjppDevice,Response))
#ifdef CJPPA_DEBUG_TRANSFER
	cjppDebugResponse(NULL, &dad, &sad, lenc, cmd, &lenr, response, Res);
#endif
	return CJPP_SUCCESS;
}


HANDLE cjppCreateThread(void (*ThreadRoutine)(void *),void *Params)
{
// 
/*
   DWORD ThreadId;
   return CreateThread(NULL,0,(  DWORD (WINAPI *)( LPVOID ))ThreadRoutine,Params,0,&ThreadId);
*/
	debug_out("cjppCreateThread - not implemented!\n");
	return NULL;
}

void cjppTerminateThread(HANDLE thread)
{
// 
/*
   TerminateThread(thread,0);
*/
	debug_out("cjppTerminateThread - not implemented!\n");
}


unsigned long cjppGetUniqueID(void)
{
   /* FIXME */
   unsigned long Result;
	debug_out("cjppTerminateThread - not implemented!\n");
#if 0
   CFUUIDRef uuid;
   unsigned long Help;
	 CFUUIDBytes		uuidBytes;
	 
	 uuid = CFUUIDCreate(NULL);
	 if ( uuid == NULL ) {
		debug_out("cjppGetUniqueID: CFUUIDCreate failed!\n");
		return 0;
	 }
	 uuidBytes = CFUUIDGetUUIDBytes(uuid);
	 CFRelease(uuid);
   memcpy(&Result,&uuidBytes.byte0,4);
   memcpy(&Help,&uuidBytes.byte4,4);
   Result^=Help;
   memcpy(&Help,&uuidBytes.byte8,4);
   Result^=Help;
   memcpy(&Help,&uuidBytes.byte12,4);
   Result^=Help;
#endif
   return Result;
}

