#define WANT_CJDEBUG 1
#include "cjppa.h"
#include "cjpp.h"
#include "cj_debug.h"
#include <CoreFoundation/CFUUID.h>
#include <CoreFoundation/CFPreferences.h>
#include "CyberJackUSBToolbox.h"


/*This Funktions must be implemented for different Platforms*/

static int cjppWaitInt(HANDLE hDevice,CCID_Interrupt *Intr,int *Fini)
{
/*
   HANDLE Ev;
   unsigned char *buffer;
   OVERLAPPED *over;
   DWORD *nRet;
   buffer=malloc(270);
   over=malloc(sizeof(OVERLAPPED));
   nRet=malloc(sizeof(DWORD));


   memset(over,0,sizeof(over));
   Ev=over->hEvent=CreateEvent(NULL,FALSE,FALSE,NULL);
   for(*nRet=0;*nRet==0 && !(*Fini);)
   {
      *nRet=0;
      ResetEvent(over->hEvent);
      over->Offset=0;
      over->OffsetHigh=0;
      memcpy(buffer,"CJCC",4);
      if(!DeviceIoControl(hDevice,IOCTL_CCID_INT,NULL,0,buffer,270,nRet,over))
      {
         if(GetLastError()!=ERROR_IO_PENDING)
         {
           CloseHandle(over->hEvent);
           free(buffer);
           free(over);
           free(nRet);
           return CJPP_ERR_DEVICE_LOST;
         }
         GetOverlappedResult(hDevice,over,nRet,TRUE);
      }
   }
   memcpy(Intr,buffer,sizeof(CCID_Interrupt));
   CloseHandle(over->hEvent);
   free(buffer);
   free(over);
   free(nRet);
   return CJPP_SUCCESS;
*/
	debug_out("### cjppWaitInt - not implemented!\n");
	return CJPP_ERR_DEVICE_LOST;
}

void MacProcessInterruptEvents(OSType inEventType,void* inDataBuffer,UInt16 inDatalen,UInt32 inUserData)
{
	cjccidHANDLE		hDevice = (cjccidHANDLE)inUserData;
	if ( inEventType == kCyberJack_CCIDEvents  &&  inDatalen >= sizeof(CCID_Interrupt) ) {
		HandleCyberJackInterruptData(hDevice, (CCID_Interrupt*)inDataBuffer);
	}
	else {
		unsigned char*	ptr = (unsigned char*)inDataBuffer;
		UInt16					i;
		debug_out("Cyberjack @ %p: Unrecognized interrupt data: size = %d, event type=0x%08lX:\n", hDevice, inDatalen, inEventType);
		for ( i = 0; i < inDatalen; ++i ) {
			 if((i%16)==0 && i+1<inDatalen) debug_out("\n        ");
			 debug_out("%02X ",(int)*ptr++);
		}
		debug_out("\n\n");
	}
}



HANDLE cjppCreate(char *cDeviceName)
{
	DeviceIdentifierRef		deviceRef;
	OSStatus							err;
	err = CyberJack_USBMacOpen(atoi(cDeviceName), &deviceRef);
	if ( err ) {
		debug_out("CyberJack: error while creating device handle: %d\n", err);
		return NULL;
	}
	return (HANDLE)deviceRef;
}


unsigned long cjppGetLocalInfo(void)
{
	CFIndex		prefsValue;
	Boolean		keyExists;
	prefsValue = CFPreferencesGetAppIntegerValue(CFSTR("pinpad2_info"), CFSTR("de.reiner-sct.cyberjack"), &keyExists);
	return keyExists ? prefsValue : 0xffffffff;
}

void cjppFillDevice(cjppHANDLE hcjppDevice)
{
}

static void cjppClose(HANDLE cjppDevice)
{
	CyberJack_USBMacClose((DeviceIdentifierRef)((cjppHANDLE)cjppDevice)->hDevice);
	free(cjppDevice);
}

void cjccidClose(HANDLE cjppDevice)
{
	CyberJack_USBMacClose((DeviceIdentifierRef)((cjppHANDLE)cjppDevice)->hDevice);
	cjppSleep(100);
}


unsigned short cjppSWAB_WORD_2(unsigned short Value)
{
   unsigned char b=(unsigned char)(Value>>8);
   Value<<=8;
   return (unsigned short)(Value+b);
}

unsigned long cjppSWAB_DWORD_2(unsigned long Value)
{
   unsigned short w=cjppSWAB_WORD_2((unsigned short)(Value>>16));
   Value=cjppSWAB_WORD_2((unsigned short)Value);
   Value<<=16;
   return Value+w;
}

unsigned short cjppSWAB_WORD(unsigned short Value)
{
   return Value;
}

unsigned long cjppSWAB_DWORD(unsigned long Value)
{
   return Value;
}


void cjppSleep(unsigned long Value)
{
   usleep(Value*1000);
}


int cjppWrite(HANDLE cjppDevice,CCID_Message *Message)
{
   unsigned char buffer[274];
	 UInt32		bytesToWrite, bytesWritten;
   memcpy(buffer,Message,270);
	
	 bytesToWrite = 10+cjppSWAB_DWORD_2(Message->dwLength);
	 bytesWritten = CyberJack_USBMacWrite((DeviceIdentifierRef)((cjppHANDLE)cjppDevice)->hDevice, bytesToWrite, buffer);
	 if ( bytesWritten < bytesToWrite ) {
		return CJPP_ERR_WRITE_DEVICE;
	 }
   return CJPP_SUCCESS;
}

int cjppTransfer(HANDLE cjppDevice,CCID_Message *Message,CCID_Response *Response)
{
   int Res;
   CJPP_TEST(cjppWrite(cjppDevice,Message))
   CJPP_TEST(cjppRead(cjppDevice,Response))
   return CJPP_SUCCESS;
}

int cjppRead(HANDLE cjppDevice,CCID_Response *Response)
{
	UInt32				bytesRead;
	UnsignedWide	timeout = { 0, 10000000 };
	
	bytesRead = 0;
	while(bytesRead == 0 || memcmp(Response,"\x00\x00\x00\x00",4)==0)
	{
		bytesRead = CyberJack_USBMacRead((DeviceIdentifierRef)((cjppHANDLE)cjppDevice)->hDevice, sizeof(CCID_Response), Response, timeout, NULL, NULL);
		if ( bytesRead == 0 ) {
			return CJPP_ERR_DEVICE_LOST;
		}
	}
	return CJPP_SUCCESS;
}


HANDLE cjppCreateThread(void (*ThreadRoutine)(void *),void *Params)
{
// 
/*
   DWORD ThreadId;
   return CreateThread(NULL,0,(  DWORD (WINAPI *)( LPVOID ))ThreadRoutine,Params,0,&ThreadId);
*/
	debug_out("cjppCreateThread - not implemented!\n");
	return NULL;
}

void cjppTerminateThread(HANDLE thread)
{
// 
/*
   TerminateThread(thread,0);
*/
	debug_out("cjppTerminateThread - not implemented!\n");
}


unsigned long cjppGetUniqueID(void)
{
   CFUUIDRef uuid;
   unsigned long Result;
   unsigned long Help;
	 CFUUIDBytes		uuidBytes;
	 
	 uuid = CFUUIDCreate(NULL);
	 if ( uuid == NULL ) {
		debug_out("cjppGetUniqueID: CFUUIDCreate failed!\n");
		return 0;
	 }
	 uuidBytes = CFUUIDGetUUIDBytes(uuid);
	 CFRelease(uuid);
   memcpy(&Result,&uuidBytes.byte0,4);
   memcpy(&Help,&uuidBytes.byte4,4);
   Result^=Help;
   memcpy(&Help,&uuidBytes.byte8,4);
   Result^=Help;
   memcpy(&Help,&uuidBytes.byte12,4);
   Result^=Help;
   return Result;
}

