/***************************************************************************
 * CT-API library for the REINER SCT cyberJack pinpad/e-com USB.
 * Copyright (C) 2001  REINER SCT
 * Author: Matthias Bruestle
 * Support: support@reiner-sct.com
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * File: cjtest.c
 * CVS: $Id:$
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "cj.h"
#include "cjio.h"
#include "cjt1.h"
#include "ctapi.h"

int main( int argc, char *argv[] )
{
	CJ_INFO *ci;
	CJ_APDU apdu;
	unsigned char cmd[5+255+1], rsp[256+1];
	int ret;

	apdu.cmd=cmd;
	apdu.rsp=rsp;

	/* Allocate CJ_INFO */
	ci = malloc( sizeof(CJ_INFO) );
	if( ci==NULL ) return -1;

	/* Open device */
	printf("cjIoOpen: ");
	ci->type=CJ_IO_TYPE_USB;
	strncpy( ci->device, CJ_IO_DEV_USB_0, sizeof(ci->device) );
	ret=cjIoOpen( ci );
	printf("%d\n",ret);
	if( ret<0 ) {
		cjIoClose( ci );
		return( ret );
	}

	/* Send a command */
	apdu.nad=0x12;
	cmd[0]=0x20;
	cmd[1]=0x13;
	cmd[2]=0x00;
	cmd[3]=0x46; /* 46 / 80 */
	cmd[4]=0x00; /* 0x00 */
	apdu.cmdlen=124; /* 5 */
	cmd[4]=apdu.cmdlen-5;
	printf("cjT1SendCmd: ");
	ret=cjT1SendCmd( ci, &apdu );
	printf("%d\n",ret);
	if( ret<0 ) {
		cjIoClose( ci );
		return( ret );
	}

	/* Close device */
	printf("cjIoClose: ");
	ret=cjIoClose( ci );
	printf("%d\n",ret);
	if( ret<0 ) return( ret );

	return 0;
}

