# generated automatically by aclocal 1.7.9 -*- Autoconf -*-

# Copyright (C) 1996, 1997, 1998, 1999, 2000, 2001, 2002
# Free Software Foundation, Inc.
# This file is free software; the Free Software Foundation
# gives unlimited permission to copy and/or distribute it,
# with or without modifications, as long as this notice is preserved.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY, to the extent permitted by law; without
# even the implied warranty of MERCHANTABILITY or FITNESS FOR A
# PARTICULAR PURPOSE.

dnl @(#)aclocal.m4	1.22 01/12/09 Copyright 1998 J. Schilling

dnl Checks if structure 'stat' have field 'st_spare1'.
dnl Defines HAVE_ST_SPARE1 on success.
AC_DEFUN(AC_STRUCT_ST_SPARE1,
[AC_CACHE_CHECK([if struct stat contains st_spare1], ac_cv_struct_st_spare1,
                [AC_TRY_COMPILE([#include <sys/types.h>
#include <sys/stat.h>],
                                [struct  stat s; s.st_spare1 = 0;],
                                [ac_cv_struct_st_spare1=yes],
                                [ac_cv_struct_st_spare1=no])])
if test $ac_cv_struct_st_spare1 = yes; then
  AC_DEFINE(HAVE_ST_SPARE1, 1, [Define if your stat structure has a st_spare1 field])
fi])

dnl Checks if structure 'stat' have field 'st_atim.tv_nsec'.
dnl Defines HAVE_ST_NSEC on success.
AC_DEFUN(AC_STRUCT_ST_NSEC,
[AC_CACHE_CHECK([if struct stat contains st_atim.tv_nsec], ac_cv_struct_st_nsec,
                [AC_TRY_COMPILE([#include <sys/types.h>
#include <sys/stat.h>],
                                [struct  stat s; s.st_atim.tv_nsec = 0;],
                                [ac_cv_struct_st_nsec=yes],
                                [ac_cv_struct_st_nsec=no])])
if test $ac_cv_struct_st_nsec = yes; then
  AC_DEFINE(HAVE_ST_NSEC, 1, [Define if your stat structure has the st_atim.tv_nsec field])
fi])

dnl Checks if structure 'stat' have field 'st_flags'.
dnl Defines HAVE_ST_FLAGS on success.
AC_DEFUN(AC_STRUCT_ST_FLAGS,
[AC_CACHE_CHECK([if struct stat contains st_flags], ac_cv_struct_st_flags,
                [AC_TRY_COMPILE([#include <sys/types.h>
#include <sys/stat.h>],
                                [struct  stat s; s.st_flags = 0;],
                                [ac_cv_struct_st_flags=yes],
                                [ac_cv_struct_st_flags=no])])
if test $ac_cv_struct_st_flags = yes; then
  AC_DEFINE(HAVE_ST_FLAGS, 1, [Define if your stat structure has st_flags])
fi])

dnl Checks if structure 'mtget' have field 'mt_type'.
dnl Defines HAVE_MTGET_TYPE on success.
AC_DEFUN(AC_STRUCT_MTGET_TYPE,
[AC_CACHE_CHECK([if struct mtget contains mt_type], ac_cv_struct_mtget_type,
                [AC_TRY_COMPILE([#include <sys/types.h>
#include <sys/mtio.h>],
                                [struct  mtget t; t.mt_type = 0;],
                                [ac_cv_struct_mtget_type=yes],
                                [ac_cv_struct_mtget_type=no])])
if test $ac_cv_struct_mtget_type = yes; then
  AC_DEFINE(HAVE_MTGET_TYPE, 1, [Define if struct mtget has mt_type])
fi])

dnl Checks if structure 'mtget' have field 'mt_dsreg'.
dnl Defines HAVE_MTGET_DSREG on success.
AC_DEFUN(AC_STRUCT_MTGET_DSREG,
[AC_CACHE_CHECK([if struct mtget contains mt_dsreg], ac_cv_struct_mtget_dsreg,
                [AC_TRY_COMPILE([#include <sys/types.h>
#include <sys/mtio.h>],
                                [struct  mtget t; t.mt_dsreg = 0;],
                                [ac_cv_struct_mtget_dsreg=yes],
                                [ac_cv_struct_mtget_dsreg=no])])
if test $ac_cv_struct_mtget_dsreg = yes; then
  AC_DEFINE(HAVE_MTGET_DSREG, 1, [Define if struct mtget has mt_dsreg])
fi])

dnl Checks if structure 'mtget' have field 'mt_erreg'.
dnl Defines HAVE_MTGET_ERREG on success.
AC_DEFUN(AC_STRUCT_MTGET_ERREG,
[AC_CACHE_CHECK([if struct mtget contains mt_erreg], ac_cv_struct_mtget_erreg,
                [AC_TRY_COMPILE([#include <sys/types.h>
#include <sys/mtio.h>],
                                [struct  mtget t; t.mt_erreg = 0;],
                                [ac_cv_struct_mtget_erreg=yes],
                                [ac_cv_struct_mtget_erreg=no])])
if test $ac_cv_struct_mtget_erreg = yes; then
  AC_DEFINE(HAVE_MTGET_ERREG, 1, [Define if struct mtget has mt_erreg])
fi])

dnl Checks if structure 'mtget' have field 'mt_resid'.
dnl Defines HAVE_MTGET_RESID on success.
AC_DEFUN(AC_STRUCT_MTGET_RESID,
[AC_CACHE_CHECK([if struct mtget contains mt_resid], ac_cv_struct_mtget_resid,
                [AC_TRY_COMPILE([#include <sys/types.h>
#include <sys/mtio.h>],
                                [struct  mtget t; t.mt_resid = 0;],
                                [ac_cv_struct_mtget_resid=yes],
                                [ac_cv_struct_mtget_resid=no])])
if test $ac_cv_struct_mtget_resid = yes; then
  AC_DEFINE(HAVE_MTGET_RESID, 1, [Define if struct mtget has mt_resid])
fi])

dnl Checks if structure 'mtget' have field 'mt_fileno'.
dnl Defines HAVE_MTGET_FILENO on success.
AC_DEFUN(AC_STRUCT_MTGET_FILENO,
[AC_CACHE_CHECK([if struct mtget contains mt_fileno],
                ac_cv_struct_mtget_fileno,
                [AC_TRY_COMPILE([#include <sys/types.h>
#include <sys/mtio.h>],
		                [struct  mtget t; t.mt_fileno = 0;],
	        	        [ac_cv_struct_mtget_fileno=yes],
                		[ac_cv_struct_mtget_fileno=no])])
if test $ac_cv_struct_mtget_fileno = yes; then
  AC_DEFINE(HAVE_MTGET_FILENO, 1, [Define if struct mtget has mt_fileno])
fi])

dnl Checks if structure 'mtget' have field 'mt_blkno'.
dnl Defines HAVE_MTGET_BLKNO on success.
AC_DEFUN(AC_STRUCT_MTGET_BLKNO,
[AC_CACHE_CHECK([if struct mtget contains mt_blkno], ac_cv_struct_mtget_blkno,
                [AC_TRY_COMPILE([#include <sys/types.h>
#include <sys/mtio.h>],
                                [struct  mtget t; t.mt_blkno = 0;],
                                [ac_cv_struct_mtget_blkno=yes],
                                [ac_cv_struct_mtget_blkno=no])])
if test $ac_cv_struct_mtget_blkno = yes; then
  AC_DEFINE(HAVE_MTGET_BLKNO, 1, [Define if struct mtget has mt_blkno])
fi])

dnl Checks if structure 'mtget' have field 'mt_flags'.
dnl Defines HAVE_MTGET_FLAGS on success.
AC_DEFUN(AC_STRUCT_MTGET_FLAGS,
[AC_CACHE_CHECK([if struct mtget contains mt_flags], ac_cv_struct_mtget_flags,
                [AC_TRY_COMPILE([#include <sys/types.h>
#include <sys/mtio.h>],
                                [struct  mtget t; t.mt_flags = 0;],
                                [ac_cv_struct_mtget_flags=yes],
                                [ac_cv_struct_mtget_flags=no])])
if test $ac_cv_struct_mtget_flags = yes; then
  AC_DEFINE(HAVE_MTGET_FLAGS, 1, [Define if struct mtget has mt_flags])
fi])

dnl Checks if structure 'mtget' have field 'mt_bf'.
dnl Defines HAVE_MTGET_BF on success.
AC_DEFUN(AC_STRUCT_MTGET_BF,
[AC_CACHE_CHECK([if struct mtget contains mt_bf], ac_cv_struct_mtget_bf,
                [AC_TRY_COMPILE([#include <sys/types.h>
#include <sys/mtio.h>],
                                [struct  mtget t; t.mt_bf = 0;],
                                [ac_cv_struct_mtget_bf=yes],
                                [ac_cv_struct_mtget_bf=no])])
if test $ac_cv_struct_mtget_bf = yes; then
  AC_DEFINE(HAVE_MTGET_BF, 1, [Define if struct mtget has mt_bf])
fi])

dnl Checks for illegal declaration of 'union semun' in sys/sem.h.
dnl Defines HAVE_UNION_SEMUN on success.
AC_DEFUN(AC_STRUCT_UNION_SEMUN,
[AC_CACHE_CHECK([if an illegal declaration for union semun in sys/sem.h exists], ac_cv_struct_union_semun,
                [AC_TRY_COMPILE([#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/sem.h>], [union semun s;],
                [ac_cv_struct_union_semun=yes],
                [ac_cv_struct_union_semun=no])])
if test $ac_cv_struct_union_semun = yes; then
  AC_DEFINE(HAVE_UNION_SEMUN, 1, [Define if union semun is defined])
fi])

dnl Checks if 'union wait' is declared in 'wait.h' or 'sys/wait.h'.
dnl Defines HAVE_UNION_WAIT on success.
AC_DEFUN(AC_STRUCT_UNION_WAIT,
[AC_CACHE_CHECK([if union wait is declared in wait.h or sys/wait.h], ac_cv_struct_union_wait,
                [AC_TRY_COMPILE([#include <sys/types.h>
#if	defined(HAVE_WAIT_H)
#	include <wait.h>
#else
#include <sys/wait.h>
#endif], [union wait w;],
                [ac_cv_struct_union_wait=yes],
                [ac_cv_struct_union_wait=no])])
if test $ac_cv_struct_union_wait = yes; then
  AC_DEFINE(HAVE_UNION_WAIT, 1, [Define if union wait exists])
fi])

dnl Checks if 'struct rusage' is declared in sys/resource.h.
dnl Defines HAVE_STRUCT_RUSAGE on success.
AC_DEFUN(AC_STRUCT_RUSAGE,
[AC_CACHE_CHECK([if struct rusage is declared in sys/resource.h], ac_cv_struct_rusage,
                [AC_TRY_COMPILE([#include <sys/time.h>
#include <sys/resource.h>], [struct rusage r;],
                [ac_cv_struct_rusage=yes],
                [ac_cv_struct_rusage=no])])
if test $ac_cv_struct_rusage = yes; then
  AC_DEFINE(HAVE_STRUCT_RUSAGE, 1, [Define if struct rusage is declared])
fi])

dnl Checks wether major(), minor() and makedev() are defined in
dnl 'sys/mkdev.h' or in 'sys/sysmacros.h. Defines MAJOR_IN_MKDEV or
dnl MAJOR_IN_SYSMACROS or nothing.
AC_DEFUN(AC_HEADER_MAKEDEV,
[AC_CACHE_CHECK([for header file containing  major(), minor() and makedev()],
               ac_cv_header_makedev,
[ac_cv_header_makedev=none
AC_TRY_COMPILE([#include <sys/types.h>
#include <sys/mkdev.h>],
               [int i = major(0); i = minor(0); i = makedev(0,0);],
                [ac_cv_header_makedev=sys/mkdev.h])
if test $ac_cv_header_makedev = none; then
  AC_TRY_COMPILE([#include <sys/types.h>
#include <sys/sysmacros.h>],
                 [int i = major(0); i = minor(0); i = makedev(0,0);],
                 [ac_cv_header_makedev=sys/sysmacros.h])
fi])
if test $ac_cv_header_makedev = sys/mkdev.h; then
  AC_DEFINE(MAJOR_IN_MKDEV, 1, [Define if the MAJOR macro is defined in mkdev.h])
fi
if test $ac_cv_header_makedev = sys/sysmacros.h; then
  AC_DEFINE(MAJOR_IN_SYSMACROS, 1, [Define if the MAJOR macro is defined in sysmacros.h])
fi])

dnl Checks for USG derived STDIO that uses _filbuf()
dnl Defines HAVE__FILBUF on success.
AC_DEFUN(AC_HEADER__FILBUF,
[AC_CACHE_CHECK([for _filbuf()], ac_cv_header__filbuf,
                [AC_TRY_LINK([#include <stdio.h>],
[FILE    *f;
int     flag;
int     count;
char    *ptr;
char	c = 0;
f = fopen("confdefs.h", "r");
_filbuf(f);
_flsbuf(c, f);
flag  = f->_flag & _IONBF;
flag |= f->_flag & _IOERR;
flag |= f->_flag & _IOEOF;
count = f->_cnt;
ptr = (char *)f->_ptr;
fclose(f);],
                [ac_cv_header__filbuf=yes],
                [ac_cv_header__filbuf=no])])
if test $ac_cv_header__filbuf = yes; then
  AC_DEFINE(HAVE__FILBUF, 1, [Define if you have _filbuf])
fi])

dnl Checks for USG derived STDIO that uses __filbuf()
dnl Defines HAVE___FILBUF on success.
AC_DEFUN(AC_HEADER___FILBUF,
[AC_CACHE_CHECK([for __filbuf()], ac_cv_header___filbuf,
                [AC_TRY_LINK([#include <stdio.h>],
[FILE    *f;
int     flag;
int     count;
char    *ptr;
char	c = 0;
f = fopen("confdefs.h", "r");
__filbuf(f);
__flsbuf(c, f);
flag  = f->_flag & _IONBF;
flag |= f->_flag & _IOERR;
flag |= f->_flag & _IOEOF;
count = f->_cnt;
ptr = (char *)f->_ptr;
fclose(f);],
                [ac_cv_header___filbuf=yes],
                [ac_cv_header___filbuf=no])])
if test $ac_cv_header___filbuf = yes; then
  AC_DEFINE(HAVE___FILBUF, 1, [Define if you have __filbuf])
fi])

dnl Checks for USG derived STDIO
dnl Defines HAVE_USG_STDIO on success.
AC_DEFUN(AC_HEADER_USG_STDIO,
[AC_REQUIRE([AC_HEADER__FILBUF])AC_REQUIRE([AC_HEADER___FILBUF])dnl
AC_CACHE_CHECK([for USG derived STDIO], ac_cv_header_usg_stdio,
                [AC_TRY_LINK([#include <stdio.h>],
[FILE    *f;
int     flag;
int     count;
char    *ptr;
char	c = 0;
f = fopen("confdefs.h", "r");
#ifdef	HAVE___FILBUF
__filbuf(f);
__flsbuf(c, f);
#else
#	ifdef	HAVE__FILBUF
_filbuf(f);
_flsbuf(c, f);
#	else
no filbuf()
#	endif
#endif
flag  = f->_flag & _IONBF;
flag |= f->_flag & _IOERR;
flag |= f->_flag & _IOEOF;
count = f->_cnt;
ptr = (char *)f->_ptr;
fclose(f);],
                [ac_cv_header_usg_stdio=yes],
                [ac_cv_header_usg_stdio=no])])
if test $ac_cv_header_usg_stdio = yes; then
  AC_DEFINE(HAVE_USG_STDIO, 1, [Define if your stdio is USG derived])
fi])

dnl Checks for errno definition in <errno.h>
dnl Defines HAVE_ERRNO_DEF on success.
AC_DEFUN(AC_HEADER_ERRNO_DEF,
[AC_CACHE_CHECK([for errno definition in errno.h], ac_cv_header_errno_def,
                [AC_TRY_COMPILE([#include <errno.h>],
[errno = 0;],
                [ac_cv_header_errno_def=yes],
                [ac_cv_header_errno_def=no])])
if test $ac_cv_header_errno_def = yes; then
  AC_DEFINE(HAVE_ERRNO_DEF, 1, [Define if errno is defined in errno.h])
fi])

dnl Checks for UNIX-98 compliant <inttypes.h>
dnl Defines HAVE_INTTYPES_H on success.
AC_DEFUN(AC_HEADER_INTTYPES,
[AC_CACHE_CHECK([for UNIX-98 compliant inttypes.h], ac_cv_header_inttypes,
                [AC_TRY_COMPILE([#include <inttypes.h>],
[int8_t c; uint8_t uc; int16_t s; uint16_t us; int32_t i; uint32_t ui;
int64_t ll; uint64_t ull;
intptr_t ip; uintptr_t uip;],
                [ac_cv_header_inttypes=yes],
                [ac_cv_header_inttypes=no])])
if test $ac_cv_header_inttypes = yes; then
  AC_DEFINE(HAVE_INTTYPES_H, 1, [Define if your inttypes.h is UNIX-98 compliant])
fi])

dnl Checks for type time_t
dnl Defines time_t to long on failure.
AC_DEFUN(AC_TYPE_TIME_T,
[AC_REQUIRE([AC_HEADER_TIME])dnl
AC_CACHE_CHECK([for time_t], ac_cv_type_time_t,
                [AC_TRY_COMPILE([
#include <sys/types.h>
#ifdef	TIME_WITH_SYS_TIME_H
#	include <sys/time.h>
#	include <time.h>
#else
#ifdef	HAVE_SYS_TIME_H
#	include <sys/time.h>
#else
#	include <time.h>
#endif
#endif], [time_t t;],
                [ac_cv_type_time_t=yes],
                [ac_cv_type_time_t=no])])
if test $ac_cv_type_time_t = no; then
  AC_DEFINE(time_t, long, [Type of time_t])
fi])

dnl Checks for type socklen_t
dnl Defines socklen_t to int on failure.
AC_DEFUN(AC_TYPE_SOCKLEN_T,
[AC_REQUIRE([AC_HEADER_STDC])dnl
AC_MSG_CHECKING(for socklen_t)
AC_CACHE_VAL(ac_cv_type_socklen_t,
[AC_EGREP_CPP(dnl
changequote(<<,>>)dnl
<<(^|[^a-zA-Z_0-9])socklen_t[^a-zA-Z_0-9]>>dnl
changequote([,]), [#include <sys/types.h>
#if STDC_HEADERS
#include <stdlib.h>
#include <stddef.h>
#endif
#include <sys/socket.h>], ac_cv_type_socklen_t=yes, ac_cv_type_socklen_t=no)])dnl
AC_MSG_RESULT($ac_cv_type_socklen_t)
if test $ac_cv_type_socklen_t = no; then
  AC_DEFINE(socklen_t, int, [Type of socklen_t])
fi])

dnl Checks for type long long
dnl Defines HAVE_LONGLONG on success.
AC_DEFUN(AC_TYPE_LONGLONG,
[AC_CACHE_CHECK([for type long long], ac_cv_type_longlong,
                [AC_TRY_COMPILE([], [long long i;],
                [ac_cv_type_longlong=yes],
                [ac_cv_type_longlong=no])])
if test $ac_cv_type_longlong = yes; then
  AC_DEFINE(HAVE_LONGLONG, 1, [Define if you have long long variables])
fi])

dnl Checks if C-compiler orders bitfields htol
dnl Defines BITFIELDS_HTOL on success.
AC_DEFUN(AC_C_BITFIELDS,
[AC_CACHE_CHECK([whether bitorder in bitfields is htol], ac_cv_c_bitfields_htol,
                [AC_TRY_RUN([
struct {
	unsigned char	x1:4;
	unsigned char	x2:4;
} a;
int
main()
{
char	*cp;

cp = (char *)&a;
*cp = 0x12;
exit(a.x1 == 2);}],
                [ac_cv_c_bitfields_htol=yes],
                [ac_cv_c_bitfields_htol=no])])
if test $ac_cv_c_bitfields_htol = yes; then
  AC_DEFINE(BITFIELDS_HTOL, 1, [Define if C-compiler orders bitfields htol])
fi])

dnl Checks if C-compiler understands prototypes
dnl Defines PROTOTYPES on success.
AC_DEFUN(AC_TYPE_PROTOTYPES,
[AC_CACHE_CHECK([for prototypes], ac_cv_type_prototypes,
                [AC_TRY_RUN([
doit(int i, ...)
{return 0;}
int
main(int ac, char *av[])
{ doit(1, 2, 3);
exit(0);}],
                [ac_cv_type_prototypes=yes],
                [ac_cv_type_prototypes=no])])
if test $ac_cv_type_prototypes = yes; then
  AC_DEFINE(PROTOTYPES, 1, [Define if your compiler understands prototypes])
fi])

dnl Checks for type size_t
dnl Defines HAVE_SIZE_T_ on success.
AC_DEFUN(AC_TYPE_SIZE_T_,
[AC_CACHE_CHECK([for type size_t], ac_cv_type_size_t_,
                [AC_TRY_COMPILE([#include <sys/types.h>], [size_t s;],
                [ac_cv_type_size_t_=yes],
                [ac_cv_type_size_t_=no])])
if test $ac_cv_type_size_t_ = yes; then
  AC_DEFINE(HAVE_SIZE_T, 1, [Define if you have size_t])
else
  AC_DEFINE(NO_SIZE_T, 1, [Define if you don't have size_t])
fi])

dnl Checks if type char is unsigned
dnl Defines CHAR_IS_UNSIGNED on success.
AC_DEFUN(AC_TYPE_CHAR,
[AC_CACHE_CHECK([if char is unsigned], ac_cv_type_char_unsigned,
                [AC_TRY_RUN([
int
main()
{
	char c;

	c = -1;
	exit(c < 0);}],
		[ac_cv_type_char_unsigned=yes],
		[ac_cv_type_char_unsigned=no],
		[ac_cv_type_char_unsigned=no])]) 
if test $ac_cv_type_char_unsigned = yes; then
  AC_DEFINE(CHAR_IS_UNSIGNED, 1, [Define if your system defaults to unsigned chars])
fi])

dnl Checks if function/macro va_copy() is available
dnl Defines HAVE_VA_COPY on success.
AC_DEFUN(AC_FUNC_VA_COPY,
[AC_CACHE_CHECK([for va_copy], ac_cv_func_va_copy,
                [AC_TRY_LINK([
#ifdef	HAVE_STDARG_H
#	include <stdarg.h>
#else
#	include <varargs.h>
#endif], 
		[
va_list a, b;

va_copy(a, b);],
                [ac_cv_func_va_copy=yes],
                [ac_cv_func_va_copy=no])])
if test $ac_cv_func_va_copy = yes; then
  AC_DEFINE(HAVE_VA_COPY, 1, [Define if you have va_copy])
fi])

dnl Checks if function/macro __va_copy() is available
dnl Defines HAVE__VA_COPY on success.
AC_DEFUN(AC_FUNC__VA_COPY,
[AC_CACHE_CHECK([for __va_copy], ac_cv_func__va_copy,
                [AC_TRY_LINK([
#ifdef	HAVE_STDARG_H
#	include <stdarg.h>
#else
#	include <varargs.h>
#endif], 
		[
va_list a, b;

__va_copy(a, b);],

                [ac_cv_func__va_copy=yes],
                [ac_cv_func__va_copy=no])])
if test $ac_cv_func__va_copy = yes; then
  AC_DEFINE(HAVE__VA_COPY, 1, [Define if you have _va_copy])
fi])

dnl Checks if va_list is an array
dnl Defines VA_LIST_IS_ARRAY on success.
AC_DEFUN(AC_TYPE_VA_LIST,
[AC_CACHE_CHECK([if va_list is an array], ac_cv_type_va_list_array,
                [AC_TRY_LINK([
#ifdef	HAVE_STDARG_H
#	include <stdarg.h>
#else
#	include <varargs.h>
#endif
],
	[
va_list a, b;

a = b;],
		[ac_cv_type_va_list_array=no],
		[ac_cv_type_va_list_array=yes])]) 
if test $ac_cv_type_va_list_array = yes; then
  AC_DEFINE(VA_LIST_IS_ARRAY, 1, [Define if va_list is an array])
fi])

dnl Checks if quotactl is present as ioctl
dnl Defines HAVE_QUOTAIOCTL on success.
AC_DEFUN(AC_FUNC_QUOTAIOCTL,
[AC_CACHE_CHECK([if quotactl is an ioctl], ac_cv_func_quotaioctl,
                [AC_TRY_LINK([#include <sys/types.h>
#include <sys/fs/ufs_quota.h>],
		[struct quotctl q; ioctl(0, Q_QUOTACTL, &q)],
		[ac_cv_func_quotaioctl=yes],
		[ac_cv_func_quotaioctl=no])]) 
if test $ac_cv_func_quotaioctl = yes; then
  AC_DEFINE(HAVE_QUOTAIOCTL, 1, [Define if you have the Q_QUOTACTL ioctl])
fi])

dnl Checks if function __dtoa() is available
dnl Defines HAVE_DTOA on success.
AC_DEFUN(AC_FUNC_DTOA,
[AC_CACHE_CHECK([for __dtoa], ac_cv_func_dtoa,
                [AC_TRY_LINK([extern  char *__dtoa();], 
[int decpt; int sign; char *ep; char *bp;
bp = __dtoa(0.0, 2, 6, &decpt, &sign, &ep);],
                [ac_cv_func_dtoa=yes],
                [ac_cv_func_dtoa=no])])
if test $ac_cv_func_dtoa = yes; then
  AC_DEFINE(HAVE_DTOA, 1, [Define if you have __dtoa])
fi])

dnl Checks if reentrant __dtoa() exists (needs a result prt)
dnl Defines HAVE_DTOA_R on success.
AC_DEFUN(AC_FUNC_DTOA_R,
[AC_REQUIRE([AC_FUNC_DTOA])dnl
AC_CACHE_CHECK([for __dtoa that needs result ptr], ac_cv_func_dtoa_r,
                [AC_TRY_RUN([
extern	char *__dtoa();
int
main()
{
#ifdef	HAVE_DTOA
	int	decpt, sign;
	char	*bp;
	char	*ep;
	char	*result;

	result = 0;
	bp = __dtoa(1.9, 2, 5, &decpt, &sign, &ep, &result);
	exit(result == 0);
#else
	exit(1);
#endif
}],
                [ac_cv_func_dtoa_r=yes],
                [ac_cv_func_dtoa_r=no])])
if test $ac_cv_func_dtoa_r = yes; then
  AC_DEFINE(HAVE_DTOA_R, 1, [Define if you have __dtoa])
fi])

dnl Checks if working ecvt() exists
dnl Defines HAVE_ECVT on success.
AC_DEFUN(AC_FUNC_ECVT,
[AC_CACHE_CHECK([for working ecvt() ], ac_cv_func_ecvt,
                [AC_TRY_RUN([
extern	char *ecvt();

sprintf(s)
	char	*s;
{
	strcpy(s, "DEAD");
}

int
main()
{
	int a, b;

/*	exit (strcmp("DEAD", ecvt(1.9, 2, &a, &b)) == 0);*/
	exit (strcmp("19", ecvt(1.9, 2, &a, &b)) != 0);
}],
                [ac_cv_func_ecvt=yes],
                [ac_cv_func_ecvt=no])])
if test $ac_cv_func_ecvt = yes; then
  AC_DEFINE(HAVE_ECVT, 1, [Define if you have a working ecvt])
fi])

dnl Checks if working fcvt() exists
dnl Defines HAVE_FCVT on success.
AC_DEFUN(AC_FUNC_FCVT,
[AC_CACHE_CHECK([for working fcvt() ], ac_cv_func_fcvt,
                [AC_TRY_RUN([
extern	char *fcvt();

sprintf(s)
	char	*s;
{
	strcpy(s, "DEAD");
}

int
main()
{
	int a, b;

/*	exit (strcmp("DEAD", fcvt(1.9, 2, &a, &b)) == 0);*/
	exit (strcmp("190", fcvt(1.9, 2, &a, &b)) != 0);
}],
                [ac_cv_func_fcvt=yes],
                [ac_cv_func_fcvt=no])])
if test $ac_cv_func_fcvt = yes; then
  AC_DEFINE(HAVE_FCVT, 1, [Define if you have a working fcvt])
fi])

dnl Checks if working gcvt() exists
dnl Defines HAVE_GCVT on success.
AC_DEFUN(AC_FUNC_GCVT,
[AC_CACHE_CHECK([for working gcvt() ], ac_cv_func_gcvt,
                [AC_TRY_RUN([
extern	char *gcvt();

sprintf(s)
	char	*s;
{
	strcpy(s, "DEAD");
}

int
main()
{
	char	buf[32];

/*	exit (strcmp("DEAD", gcvt(1.9, 10, buf)) == 0);*/
	exit (strcmp("1.9", gcvt(1.9, 10, buf)) != 0);
}],
                [ac_cv_func_gcvt=yes],
                [ac_cv_func_gcvt=no])])
if test $ac_cv_func_gcvt = yes; then
  AC_DEFINE(HAVE_GCVT, 1, [Define if you have a working gcvt])
fi])

dnl Checks if function uname() is available
dnl Defines HAVE_UNAME on success.
AC_DEFUN(AC_FUNC_UNAME,
[AC_CACHE_CHECK([for uname], ac_cv_func_uname,
                [AC_TRY_LINK([#include <sys/utsname.h>], 
[struct	utsname un;
uname(&un);],
                [ac_cv_func_uname=yes],
                [ac_cv_func_uname=no])])
if test $ac_cv_func_uname = yes; then
  AC_DEFINE(HAVE_UNAME, 1, [Define if you have uname])  dnl FIXME simply use AC_CHECK_FUNCS
fi])

dnl Checks if function mlockall() is available
dnl beware HP-UX 10.x it contains a bad mlockall() in libc
dnl Defines HAVE_MLOCKALL on success.
AC_DEFUN(AC_FUNC_MLOCKALL,
[AC_CACHE_CHECK([for mlockall], ac_cv_func_mlockall,
                [AC_TRY_RUN([
#include <sys/types.h>
#include <sys/mman.h>
#include <errno.h>

int
main()
{
	if (mlockall(MCL_CURRENT|MCL_FUTURE) < 0) {
		if (errno == EPERM || errno ==  EACCES)
			exit(0);
		exit(-1);
	}
	exit(0);
}
],
                [ac_cv_func_mlockall=yes],
                [ac_cv_func_mlockall=no])])
if test $ac_cv_func_mlockall = yes; then
  AC_DEFINE(HAVE_MLOCKALL, 1, [Define if you have mlockall])
fi])

AC_DEFUN(jsAC_FUNC_MMAP,
[AC_REQUIRE([AC_MMAP_SIZEP])dnl
AC_CHECK_HEADERS(unistd.h)
AC_CHECK_FUNCS(getpagesize)
AC_CACHE_CHECK(for working mmap, ac_cv_func_mmap_fixed_mapped,
[AC_TRY_RUN([
/* Thanks to Mike Haertel and Jim Avera for this test.
   Here is a matrix of mmap possibilities:
	mmap private not fixed
	mmap private fixed at somewhere currently unmapped
	mmap private fixed at somewhere already mapped
	mmap shared not fixed
	mmap shared fixed at somewhere currently unmapped
	mmap shared fixed at somewhere already mapped
   For private mappings, we should verify that changes cannot be read()
   back from the file, nor mmap's back from the file at a different
   address.  (There have been systems where private was not correctly
   implemented like the infamous i386 svr4.0, and systems where the
   VM page cache was not coherent with the filesystem buffer cache
   like early versions of FreeBSD and possibly contemporary NetBSD.)
   For shared mappings, we should conversely verify that changes get
   propogated back to all the places they're supposed to be.

   Grep wants private fixed already mapped.
   The main things grep needs to know about mmap are:
   * does it exist and is it safe to write into the mmap'd area
   * how to use it (BSD variants)  */
#include <sys/types.h>
#include <fcntl.h>
#include <sys/mman.h>

/*
 * Needed for Apollo Domain/OS and may be for others?
 */
#ifdef	_MMAP_WITH_SIZEP
#	define	mmap_sizeparm(s)	(&(s))
#else
#	define	mmap_sizeparm(s)	(s)
#endif

/* This mess was copied from the GNU getpagesize.h.  */
#ifndef HAVE_GETPAGESIZE
# ifdef HAVE_UNISTD_H
#  include <unistd.h>
# endif

/* Assume that all systems that can run configure have sys/param.h.  */
# ifndef HAVE_SYS_PARAM_H
#  define HAVE_SYS_PARAM_H 1
# endif

# ifdef _SC_PAGESIZE
#  define getpagesize() sysconf(_SC_PAGESIZE)
# else /* no _SC_PAGESIZE */
#  ifdef HAVE_SYS_PARAM_H
#   include <sys/param.h>
#   ifdef EXEC_PAGESIZE
#    define getpagesize() EXEC_PAGESIZE
#   else /* no EXEC_PAGESIZE */
#    ifdef NBPG
#     define getpagesize() NBPG * CLSIZE
#     ifndef CLSIZE
#      define CLSIZE 1
#     endif /* no CLSIZE */
#    else /* no NBPG */
#     ifdef NBPC
#      define getpagesize() NBPC
#     else /* no NBPC */
#      ifdef PAGESIZE
#       define getpagesize() PAGESIZE
#      endif /* PAGESIZE */
#     endif /* no NBPC */
#    endif /* no NBPG */
#   endif /* no EXEC_PAGESIZE */
#  else /* no HAVE_SYS_PARAM_H */
#   define getpagesize() 8192	/* punt totally */
#  endif /* no HAVE_SYS_PARAM_H */
# endif /* no _SC_PAGESIZE */

#endif /* no HAVE_GETPAGESIZE */

#ifdef __cplusplus
extern "C" { void *malloc(unsigned); }
#else
char *malloc();
#endif

int
main()
{
	char *data, *data2, *data3;
	int i, pagesize;
	int fd;

	pagesize = getpagesize();

	/*
	 * First, make a file with some known garbage in it.
	 */
	data = malloc(pagesize);
	if (!data)
		exit(1);
	for (i = 0; i < pagesize; ++i)
		*(data + i) = rand();
	umask(0);
	fd = creat("conftestmmap", 0600);
	if (fd < 0)
		exit(1);
	if (write(fd, data, pagesize) != pagesize)
		exit(1);
	close(fd);

	/*
	 * Next, try to mmap the file at a fixed address which
	 * already has something else allocated at it.  If we can,
	 * also make sure that we see the same garbage.
	 */
	fd = open("conftestmmap", O_RDWR);
	if (fd < 0)
		exit(1);
	data2 = malloc(2 * pagesize);
	if (!data2)
		exit(1);
	data2 += (pagesize - ((int) data2 & (pagesize - 1))) & (pagesize - 1);
	if (data2 != mmap(data2, mmap_sizeparm(pagesize), PROT_READ | PROT_WRITE,
	    MAP_PRIVATE | MAP_FIXED, fd, 0L))
		exit(1);
	for (i = 0; i < pagesize; ++i)
		if (*(data + i) != *(data2 + i))
			exit(1);

	/*
	 * Finally, make sure that changes to the mapped area
	 * do not percolate back to the file as seen by read().
	 * (This is a bug on some variants of i386 svr4.0.)
	 */
	for (i = 0; i < pagesize; ++i)
		*(data2 + i) = *(data2 + i) + 1;
	data3 = malloc(pagesize);
	if (!data3)
		exit(1);
	if (read(fd, data3, pagesize) != pagesize)
		exit(1);
	for (i = 0; i < pagesize; ++i)
		if (*(data + i) != *(data3 + i))
			exit(1);
	close(fd);
	unlink("conftestmmap");
	exit(0);
}
], ac_cv_func_mmap_fixed_mapped=yes, ac_cv_func_mmap_fixed_mapped=no,
ac_cv_func_mmap_fixed_mapped=no)])
if test $ac_cv_func_mmap_fixed_mapped = yes; then
  AC_DEFINE(HAVE_MMAP, 1, [Define if you have a working mmap])
fi
])

AC_DEFUN(AC_MMAP_SIZEP,
[AC_CHECK_HEADERS(unistd.h)
AC_CHECK_FUNCS(getpagesize)
AC_CACHE_CHECK(for mmap that needs ptr to size, ac_cv_func_mmap_sizep,
[AC_TRY_RUN([
#include <sys/types.h>
#include <fcntl.h>
#include <signal.h>
#include <setjmp.h>
#include <sys/mman.h>

#ifndef MAP_FILE
#define MAP_FILE   0		/* Needed on Apollo Domain/OS */
#endif

/* This mess was copied from the GNU getpagesize.h.  */
#ifndef HAVE_GETPAGESIZE
# ifdef HAVE_UNISTD_H
#  include <unistd.h>
# endif

/* Assume that all systems that can run configure have sys/param.h.  */
# ifndef HAVE_SYS_PARAM_H
#  define HAVE_SYS_PARAM_H 1
# endif

# ifdef _SC_PAGESIZE
#  define getpagesize() sysconf(_SC_PAGESIZE)
# else /* no _SC_PAGESIZE */
#  ifdef HAVE_SYS_PARAM_H
#   include <sys/param.h>
#   ifdef EXEC_PAGESIZE
#    define getpagesize() EXEC_PAGESIZE
#   else /* no EXEC_PAGESIZE */
#    ifdef NBPG
#     define getpagesize() NBPG * CLSIZE
#     ifndef CLSIZE
#      define CLSIZE 1
#     endif /* no CLSIZE */
#    else /* no NBPG */
#     ifdef NBPC
#      define getpagesize() NBPC
#     else /* no NBPC */
#      ifdef PAGESIZE
#       define getpagesize() PAGESIZE
#      endif /* PAGESIZE */
#     endif /* no NBPC */
#    endif /* no NBPG */
#   endif /* no EXEC_PAGESIZE */
#  else /* no HAVE_SYS_PARAM_H */
#   define getpagesize() 8192	/* punt totally */
#  endif /* no HAVE_SYS_PARAM_H */
# endif /* no _SC_PAGESIZE */

#endif /* no HAVE_GETPAGESIZE */

#ifdef __cplusplus
extern "C" { void *malloc(unsigned); }
#else
char *malloc();
#endif

jmp_buf jenv;

int
intr()
{
	signal(SIGSEGV, intr);
	longjmp(jenv, 1);
}

int
main()
{
	char *data, *data2;
	int i, pagesize, ps;
	int fd;

	pagesize = getpagesize();

	/*
	 * First, make a file with some known garbage in it.
	 */
	data = malloc(pagesize);
	if (!data)
		exit(1);
	for (i = 0; i < pagesize; ++i)
		*(data + i) = rand();
	umask(0);
	fd = creat("conftestmmap", 0600);
	if (fd < 0)
		exit(1);
	if (write(fd, data, pagesize) != pagesize)
		exit(1);
	close(fd);

	/*
	 * Next, try to mmap the file at a fixed address which
	 * already has something else allocated at it.  If we can,
	 * also make sure that we see the same garbage.
	 */
	fd = open("conftestmmap", O_RDWR);
	if (fd < 0)
		exit(1);

	/*
	 * Keep a copy, Apollo modifies the value...
	 */
	ps = pagesize;

	/*
	 * Apollo mmap() is not a syscall but a library function and fails
	 * if it tries to dereference 'ps'. We must use setjmp in order to
	 * catch the failure.
	 */
	signal(SIGSEGV, intr);
	if (setjmp(jenv) == 0) {
		data2 = mmap(0, ps, PROT_READ, MAP_FILE | MAP_PRIVATE, fd, 0L);
	} else {
		data2 = (char *)-1;
	}
	if (data2 != (char *)-1)
		exit(1);

	signal(SIGSEGV, intr);
	if (setjmp(jenv) == 0) {
		data2 = mmap(0, &ps, PROT_READ, MAP_FILE | MAP_PRIVATE, fd, 0L);
	} else {
		data2 = (char *)-1;
	}
	if (data2 == (char *)-1)
		exit(1);

	for (i = 0; i < pagesize; ++i)
		if (*(data + i) != *(data2 + i))
			exit(1);

	close(fd);
	unlink("conftestmmap");
	exit(0);
}
], ac_cv_func_mmap_sizep=yes, ac_cv_func_mmap_sizep=no,
ac_cv_func_mmap_sizep=no)])
if test $ac_cv_func_mmap_sizep = yes; then
  AC_DEFINE(_MMAP_WITH_SIZEP, 1, [Define if your mmap handles sizep])
fi
])

dnl Checks if mmap() works to get shared memory
dnl Defines HAVE_SMMAP on success.
AC_DEFUN(AC_FUNC_SMMAP,
[AC_CACHE_CHECK([if mmap works to get shared memory], ac_cv_func_smmap,
                [AC_TRY_RUN([
#include <sys/types.h>
#include <sys/mman.h>

#ifndef	MAP_ANONYMOUS
#	ifdef	MAP_ANON
#		define MAP_ANONYMOUS MAP_ANON
#	endif
#endif

/*
 * Needed for Apollo Domain/OS and may be for others?
 */
#ifdef	_MMAP_WITH_SIZEP
#	define	mmap_sizeparm(s)	(&(s))
#else
#	define	mmap_sizeparm(s)	(s)
#endif

char *
mkshare()
{
        int     size = 8192;
        int     f;
        char    *addr;

#ifdef  MAP_ANONYMOUS   /* HP/UX */
        f = -1;
        addr = mmap(0, mmap_sizeparm(size), PROT_READ|PROT_WRITE, MAP_SHARED|MAP_ANONYMOUS, f, 0);
#else
        if ((f = open("/dev/zero", 2)) < 0)
                exit(1);
        addr = mmap(0, mmap_sizeparm(size), PROT_READ|PROT_WRITE, MAP_SHARED, f, 0);
#endif
        if (addr == (char *)-1)
                exit(1);
        close(f);

        return (addr);
}

int
main()
{
        char    *addr;
        
        addr = mkshare();
        *addr = 'I';

        switch (fork()) {

        case -1:
                printf("help\n"); exit(1);

        case 0: /* child */
                *addr = 'N';
                _exit(0);
                break;
        default: /* parent */
                wait(0);
                sleep(1);
                break;
        }

        if (*addr != 'N')
                exit(1);
        exit(0);
}
], 
                [ac_cv_func_smmap=yes],
                [ac_cv_func_smmap=no],
                [ac_cv_func_smmap=no])])
if test $ac_cv_func_smmap = yes; then
  AC_DEFINE(HAVE_SMMAP, 1, [Define if you map can get shared memory])
fi])

dnl Checks if sys_siglist[] exists
dnl Defines HAVE_SYS_SIGLIST on success.
AC_DEFUN(AC_FUNC_SYS_SIGLIST,
[AC_CACHE_CHECK([for sys_siglist], ac_cv_func_sys_siglist,
                [AC_TRY_RUN([
int
main()
{ extern char *sys_siglist[];
if (sys_siglist[1] == 0)
	exit(1);
exit(0);}],
                [ac_cv_func_sys_siglist=yes],
                [ac_cv_func_sys_siglist=no])])
if test $ac_cv_func_sys_siglist = yes; then
  AC_DEFINE(HAVE_SYS_SIGLIST, 1, [Define if your system defines sys_siglist])
fi])

dnl Checks for maximum number of bits in minor device number
AC_DEFUN(AC_CHECK_MINOR_BITS,
[AC_REQUIRE([AC_HEADER_MAKEDEV])dnl
changequote(<<, >>)dnl
define(<<AC_MACRO_NAME>>, DEV_MINOR_BITS)dnl
dnl The cache variable name.
define(<<AC_CV_NAME>>, ac_cv_dev_minor_bits)dnl
changequote([, ])dnl
AC_MSG_CHECKING(bits in minor device number)
AC_CACHE_VAL(AC_CV_NAME,
[AC_TRY_RUN([#include <stdio.h>
#include <sys/types.h>
#ifdef major
#	define _FOUND_MAJOR_
#endif

#ifdef MAJOR_IN_MKDEV
#	include <sys/mkdev.h>
#	define _FOUND_MAJOR_
#endif

#ifndef _FOUND_MAJOR_
#	ifdef MAJOR_IN_SYSMACROS
#		include <sys/sysmacros.h>
#		define _FOUND_MAJOR_
#	endif
#endif

#ifndef _FOUND_MAJOR_
#	if defined(hpux) || defined(__hpux__) || defined(__hpux)
#		include <sys/mknod.h>
#		define _FOUND_MAJOR_
#	endif
#endif

#ifndef _FOUND_MAJOR_
#	define major(dev)		(((dev) >> 8) & 0xFF)
#	define minor(dev)		((dev) & 0xFF)
#	define makedev(majo, mino)	(((majo) << 8) | (mino))
#endif
int
main()
{
	long	l = 1;
	int	i;
	int	m;
	int	c = 0;
	FILE	*f=fopen("conftestval", "w");

	if (!f) exit(1);

	for (i=1, m=0; i <= 32; i++, l<<=1) {
		if (minor(l) == 0 && c == 0)
			c = m;
		if (minor(l) != 0)
			m = i;
	}
	fprintf(f, "%d\n", m);
	exit(0);
}], AC_CV_NAME=`cat conftestval`, AC_CV_NAME=0, ifelse([$2], , , AC_CV_NAME=$2))])dnl
AC_MSG_RESULT($AC_CV_NAME)
AC_DEFINE_UNQUOTED(AC_MACRO_NAME, $AC_CV_NAME, [Macro name])
undefine([AC_MACRO_NAME])dnl
undefine([AC_CV_NAME])dnl
])

dnl Checks for maximum number of bits in minor device numbers are non contiguous
dnl Defines DEV_MINOR_NONCONTIG on success.
AC_DEFUN(AC_CHECK_MINOR_NONCONTIG,
[AC_REQUIRE([AC_HEADER_MAKEDEV])dnl
AC_CACHE_CHECK([whether bits in minor device numbers are non contiguous], ac_cv_dev_minor_noncontig,
                [AC_TRY_RUN([
#include <sys/types.h>
#ifdef major
#	define _FOUND_MAJOR_
#endif

#ifdef MAJOR_IN_MKDEV
#	include <sys/mkdev.h>
#	define _FOUND_MAJOR_
#endif

#ifndef _FOUND_MAJOR_
#	ifdef MAJOR_IN_SYSMACROS
#		include <sys/sysmacros.h>
#		define _FOUND_MAJOR_
#	endif
#endif

#ifndef _FOUND_MAJOR_
#	if defined(hpux) || defined(__hpux__) || defined(__hpux)
#		include <sys/mknod.h>
#		define _FOUND_MAJOR_
#	endif
#endif

#ifndef _FOUND_MAJOR_
#	define major(dev)		(((dev) >> 8) & 0xFF)
#	define minor(dev)		((dev) & 0xFF)
#	define makedev(majo, mino)	(((majo) << 8) | (mino))
#endif
int
main()
{
	long	l = 1;
	int	i;
	int	m;
	int	c = 0;

	for (i=1, m=0; i <= 32; i++, l<<=1) {
		if (minor(l) == 0 && c == 0)
			c = m;
		if (minor(l) != 0)
			m = i;
	}
exit (m == c);}],
                [ac_cv_dev_minor_noncontig=yes],
                [ac_cv_dev_minor_noncontig=no])])
if test $ac_cv_dev_minor_noncontig = yes; then
  AC_DEFINE(DEV_MINOR_NONCONTIG, 1, [Define if bits in minor device numbers are non contiguous])
fi])

dnl Checks if we may not define our own malloc()
dnl Defines NO_USER_MALLOC if we cannot.
AC_DEFUN(AC_USER_MALLOC,
[AC_CACHE_CHECK([if we may not define our own malloc()], ac_cv_no_user_malloc,
                [AC_TRY_LINK([
char * malloc(x)
	int     x; 
{
	return ((char *)0);
}],
[],
                [ac_cv_no_user_malloc=no],
                [ac_cv_no_user_malloc=yes])])
if test $ac_cv_no_user_malloc = yes; then
  AC_DEFINE(NO_USER_MALLOC, 1, [Define if applications may not redefine malloc])
fi])

dnl Checks if select() needs more than sys/time.h & sys/types.h
dnl Defines SELECT_NONSTD_HDR on success.
AC_DEFUN(AC_HEADER_SELECT_NONSTD,
[AC_CACHE_CHECK([if select needs nonstd include files], ac_cv_header_slect_nonstd_hdr,
                [AC_TRY_COMPILE([#include <sys/types.h>
#include <sys/time.h>],
			[fd_set rfd; FD_ZERO(&rfd); select(1, &rfd, 0, 0, 0);],
				[ac_cv_header_slect_nonstd_hdr=no],
				[ac_cv_header_slect_nonstd_hdr=yes])])
if test $ac_cv_header_slect_nonstd_hdr = yes; then
  AC_DEFINE(SELECT_NONSTD_HDR, 1, [Define if select needs nonstandard includes])
fi])

dnl Checks if select() needs sys/select.h
dnl Defines NEED_SYS_SELECT_H on success.
AC_DEFUN(AC_HEADER_SYS_SELECT,
[AC_REQUIRE([AC_HEADER_SELECT_NONSTD])dnl
AC_CACHE_CHECK([if sys/select.h is needed for select], ac_cv_header_need_sys_select_h,
                [AC_TRY_COMPILE([#include <sys/types.h>
#include <sys/time.h>
#include <sys/select.h>
#ifndef	SELECT_NONSTD_HDR
do not compile if we do not need nonstandard headers
#endif],
			[fd_set rfd; FD_ZERO(&rfd); select(1, &rfd, 0, 0, 0);],
				[ac_cv_header_need_sys_select_h=yes],
				[ac_cv_header_need_sys_select_h=no])])
if test $ac_cv_header_need_sys_select_h = yes; then
  AC_DEFINE(NEED_SYS_SELECT_H, 1, [Define if you need to include sys/select.h])
fi])

dnl Checks if select() needs sys/socket.h
dnl Defines NEED_SYS_SOCKET_H on success.
AC_DEFUN(AC_HEADER_SELECT2,
[AC_REQUIRE([AC_HEADER_SELECT_NONSTD])dnl
AC_CACHE_CHECK([if sys/socket.h is needed for select], ac_cv_header_need_sys_socket_h,
                [AC_TRY_COMPILE([#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#ifndef	SELECT_NONSTD_HDR
do not compile if we do not need nonstandard headers
#endif],
			[fd_set rfd; FD_ZERO(&rfd); select(1, &rfd, 0, 0, 0);],
				[ac_cv_header_need_sys_socket_h=yes],
				[ac_cv_header_need_sys_socket_h=no])])
if test $ac_cv_header_need_sys_socket_h = yes; then
  AC_DEFINE(NEED_SYS_SOCKET_H, 1, [Define if you need sys/socket.h])
fi])

dnl Checks if file locking via fcntl() is available
dnl Defines HAVE_FCNTL_LOCKF on success.
AC_DEFUN(AC_FUNC_FCNTL_LOCKF,
[AC_CACHE_CHECK([for file locking via fcntl], ac_cv_func_fcntl_lock,
                [AC_TRY_LINK([
#include <sys/types.h>
#include <fcntl.h>], 
		[
struct flock fl;
fcntl(0, F_SETLK, &fl);],
                [ac_cv_func_fcntl_lock=yes],
                [ac_cv_func_fcntl_lock=no])])
if test $ac_cv_func_fcntl_lock = yes; then
  AC_DEFINE(HAVE_FCNTL_LOCKF, 1, [Define if you can lock files via fcntl])
fi])

AC_DEFUN(AC_HAVE_LARGEFILES,
[AC_REQUIRE([AC_SYS_LARGEFILE])
AC_CACHE_CHECK([if system supports Large Files at all], ac_cv_largefiles,
     	[AC_TRY_COMPILE([#define _LARGEFILE_SOURCE
#include <stdio.h>
#include <sys/types.h>],
     		[
/*
 * Check that off_t can represent 2**63 - 1 correctly.
 * We can't simply "#define LARGE_OFF_T 9223372036854775807",
 * since some C++ compilers masquerading as C compilers
 * incorrectly reject 9223372036854775807.
 */
#   define LARGE_OFF_T (((off_t) 1 << 62) - 1 + ((off_t) 1 << 62))
    int off_t_is_large[(LARGE_OFF_T % 2147483629 == 721
			&& LARGE_OFF_T % 2147483647 == 1)
		       ? 1 : -1];
return !fseeko;
return !ftello;],
     		[ac_cv_largefiles=yes],
     		[ac_cv_largefiles=no])])
	if test $ac_cv_largefiles = yes; then
		AC_DEFINE(HAVE_LARGEFILES, 1, [Define if you support files > 2GB])
	fi])

# Do all the work for Automake.                            -*- Autoconf -*-

# This macro actually does too much some checks are only needed if
# your package does certain things.  But this isn't really a big deal.

# Copyright (C) 1996, 1997, 1998, 1999, 2000, 2001, 2002, 2003
# Free Software Foundation, Inc.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.

# serial 10

AC_PREREQ([2.54])

# Autoconf 2.50 wants to disallow AM_ names.  We explicitly allow
# the ones we care about.
m4_pattern_allow([^AM_[A-Z]+FLAGS$])dnl

# AM_INIT_AUTOMAKE(PACKAGE, VERSION, [NO-DEFINE])
# AM_INIT_AUTOMAKE([OPTIONS])
# -----------------------------------------------
# The call with PACKAGE and VERSION arguments is the old style
# call (pre autoconf-2.50), which is being phased out.  PACKAGE
# and VERSION should now be passed to AC_INIT and removed from
# the call to AM_INIT_AUTOMAKE.
# We support both call styles for the transition.  After
# the next Automake release, Autoconf can make the AC_INIT
# arguments mandatory, and then we can depend on a new Autoconf
# release and drop the old call support.
AC_DEFUN([AM_INIT_AUTOMAKE],
[AC_REQUIRE([AM_SET_CURRENT_AUTOMAKE_VERSION])dnl
 AC_REQUIRE([AC_PROG_INSTALL])dnl
# test to see if srcdir already configured
if test "`cd $srcdir && pwd`" != "`pwd`" &&
   test -f $srcdir/config.status; then
  AC_MSG_ERROR([source directory already configured; run "make distclean" there first])
fi

# test whether we have cygpath
if test -z "$CYGPATH_W"; then
  if (cygpath --version) >/dev/null 2>/dev/null; then
    CYGPATH_W='cygpath -w'
  else
    CYGPATH_W=echo
  fi
fi
AC_SUBST([CYGPATH_W])

# Define the identity of the package.
dnl Distinguish between old-style and new-style calls.
m4_ifval([$2],
[m4_ifval([$3], [_AM_SET_OPTION([no-define])])dnl
 AC_SUBST([PACKAGE], [$1])dnl
 AC_SUBST([VERSION], [$2])],
[_AM_SET_OPTIONS([$1])dnl
 AC_SUBST([PACKAGE], ['AC_PACKAGE_TARNAME'])dnl
 AC_SUBST([VERSION], ['AC_PACKAGE_VERSION'])])dnl

_AM_IF_OPTION([no-define],,
[AC_DEFINE_UNQUOTED(PACKAGE, "$PACKAGE", [Name of package])
 AC_DEFINE_UNQUOTED(VERSION, "$VERSION", [Version number of package])])dnl

# Some tools Automake needs.
AC_REQUIRE([AM_SANITY_CHECK])dnl
AC_REQUIRE([AC_ARG_PROGRAM])dnl
AM_MISSING_PROG(ACLOCAL, aclocal-${am__api_version})
AM_MISSING_PROG(AUTOCONF, autoconf)
AM_MISSING_PROG(AUTOMAKE, automake-${am__api_version})
AM_MISSING_PROG(AUTOHEADER, autoheader)
AM_MISSING_PROG(MAKEINFO, makeinfo)
AM_MISSING_PROG(AMTAR, tar)
AM_PROG_INSTALL_SH
AM_PROG_INSTALL_STRIP
# We need awk for the "check" target.  The system "awk" is bad on
# some platforms.
AC_REQUIRE([AC_PROG_AWK])dnl
AC_REQUIRE([AC_PROG_MAKE_SET])dnl
AC_REQUIRE([AM_SET_LEADING_DOT])dnl

_AM_IF_OPTION([no-dependencies],,
[AC_PROVIDE_IFELSE([AC_PROG_CC],
                  [_AM_DEPENDENCIES(CC)],
                  [define([AC_PROG_CC],
                          defn([AC_PROG_CC])[_AM_DEPENDENCIES(CC)])])dnl
AC_PROVIDE_IFELSE([AC_PROG_CXX],
                  [_AM_DEPENDENCIES(CXX)],
                  [define([AC_PROG_CXX],
                          defn([AC_PROG_CXX])[_AM_DEPENDENCIES(CXX)])])dnl
])
])


# When config.status generates a header, we must update the stamp-h file.
# This file resides in the same directory as the config header
# that is generated.  The stamp files are numbered to have different names.

# Autoconf calls _AC_AM_CONFIG_HEADER_HOOK (when defined) in the
# loop where config.status creates the headers, so we can generate
# our stamp files there.
AC_DEFUN([_AC_AM_CONFIG_HEADER_HOOK],
[# Compute $1's index in $config_headers.
_am_stamp_count=1
for _am_header in $config_headers :; do
  case $_am_header in
    $1 | $1:* )
      break ;;
    * )
      _am_stamp_count=`expr $_am_stamp_count + 1` ;;
  esac
done
echo "timestamp for $1" >`AS_DIRNAME([$1])`/stamp-h[]$_am_stamp_count])

# Copyright 2002  Free Software Foundation, Inc.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA

# AM_AUTOMAKE_VERSION(VERSION)
# ----------------------------
# Automake X.Y traces this macro to ensure aclocal.m4 has been
# generated from the m4 files accompanying Automake X.Y.
AC_DEFUN([AM_AUTOMAKE_VERSION],[am__api_version="1.7"])

# AM_SET_CURRENT_AUTOMAKE_VERSION
# -------------------------------
# Call AM_AUTOMAKE_VERSION so it can be traced.
# This function is AC_REQUIREd by AC_INIT_AUTOMAKE.
AC_DEFUN([AM_SET_CURRENT_AUTOMAKE_VERSION],
	 [AM_AUTOMAKE_VERSION([1.7.9])])

# Helper functions for option handling.                    -*- Autoconf -*-

# Copyright 2001, 2002  Free Software Foundation, Inc.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.

# serial 2

# _AM_MANGLE_OPTION(NAME)
# -----------------------
AC_DEFUN([_AM_MANGLE_OPTION],
[[_AM_OPTION_]m4_bpatsubst($1, [[^a-zA-Z0-9_]], [_])])

# _AM_SET_OPTION(NAME)
# ------------------------------
# Set option NAME.  Presently that only means defining a flag for this option.
AC_DEFUN([_AM_SET_OPTION],
[m4_define(_AM_MANGLE_OPTION([$1]), 1)])

# _AM_SET_OPTIONS(OPTIONS)
# ----------------------------------
# OPTIONS is a space-separated list of Automake options.
AC_DEFUN([_AM_SET_OPTIONS],
[AC_FOREACH([_AM_Option], [$1], [_AM_SET_OPTION(_AM_Option)])])

# _AM_IF_OPTION(OPTION, IF-SET, [IF-NOT-SET])
# -------------------------------------------
# Execute IF-SET if OPTION is set, IF-NOT-SET otherwise.
AC_DEFUN([_AM_IF_OPTION],
[m4_ifset(_AM_MANGLE_OPTION([$1]), [$2], [$3])])

#
# Check to make sure that the build environment is sane.
#

# Copyright 1996, 1997, 2000, 2001 Free Software Foundation, Inc.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.

# serial 3

# AM_SANITY_CHECK
# ---------------
AC_DEFUN([AM_SANITY_CHECK],
[AC_MSG_CHECKING([whether build environment is sane])
# Just in case
sleep 1
echo timestamp > conftest.file
# Do `set' in a subshell so we don't clobber the current shell's
# arguments.  Must try -L first in case configure is actually a
# symlink; some systems play weird games with the mod time of symlinks
# (eg FreeBSD returns the mod time of the symlink's containing
# directory).
if (
   set X `ls -Lt $srcdir/configure conftest.file 2> /dev/null`
   if test "$[*]" = "X"; then
      # -L didn't work.
      set X `ls -t $srcdir/configure conftest.file`
   fi
   rm -f conftest.file
   if test "$[*]" != "X $srcdir/configure conftest.file" \
      && test "$[*]" != "X conftest.file $srcdir/configure"; then

      # If neither matched, then we have a broken ls.  This can happen
      # if, for instance, CONFIG_SHELL is bash and it inherits a
      # broken ls alias from the environment.  This has actually
      # happened.  Such a system could not be considered "sane".
      AC_MSG_ERROR([ls -t appears to fail.  Make sure there is not a broken
alias in your environment])
   fi

   test "$[2]" = conftest.file
   )
then
   # Ok.
   :
else
   AC_MSG_ERROR([newly created file is older than distributed files!
Check your system clock])
fi
AC_MSG_RESULT(yes)])

#  -*- Autoconf -*-


# Copyright 1997, 1999, 2000, 2001 Free Software Foundation, Inc.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.

# serial 3

# AM_MISSING_PROG(NAME, PROGRAM)
# ------------------------------
AC_DEFUN([AM_MISSING_PROG],
[AC_REQUIRE([AM_MISSING_HAS_RUN])
$1=${$1-"${am_missing_run}$2"}
AC_SUBST($1)])


# AM_MISSING_HAS_RUN
# ------------------
# Define MISSING if not defined so far and test if it supports --run.
# If it does, set am_missing_run to use it, otherwise, to nothing.
AC_DEFUN([AM_MISSING_HAS_RUN],
[AC_REQUIRE([AM_AUX_DIR_EXPAND])dnl
test x"${MISSING+set}" = xset || MISSING="\${SHELL} $am_aux_dir/missing"
# Use eval to expand $SHELL
if eval "$MISSING --run true"; then
  am_missing_run="$MISSING --run "
else
  am_missing_run=
  AC_MSG_WARN([`missing' script is too old or missing])
fi
])

# AM_AUX_DIR_EXPAND

# Copyright 2001 Free Software Foundation, Inc.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.

# For projects using AC_CONFIG_AUX_DIR([foo]), Autoconf sets
# $ac_aux_dir to `$srcdir/foo'.  In other projects, it is set to
# `$srcdir', `$srcdir/..', or `$srcdir/../..'.
#
# Of course, Automake must honor this variable whenever it calls a
# tool from the auxiliary directory.  The problem is that $srcdir (and
# therefore $ac_aux_dir as well) can be either absolute or relative,
# depending on how configure is run.  This is pretty annoying, since
# it makes $ac_aux_dir quite unusable in subdirectories: in the top
# source directory, any form will work fine, but in subdirectories a
# relative path needs to be adjusted first.
#
# $ac_aux_dir/missing
#    fails when called from a subdirectory if $ac_aux_dir is relative
# $top_srcdir/$ac_aux_dir/missing
#    fails if $ac_aux_dir is absolute,
#    fails when called from a subdirectory in a VPATH build with
#          a relative $ac_aux_dir
#
# The reason of the latter failure is that $top_srcdir and $ac_aux_dir
# are both prefixed by $srcdir.  In an in-source build this is usually
# harmless because $srcdir is `.', but things will broke when you
# start a VPATH build or use an absolute $srcdir.
#
# So we could use something similar to $top_srcdir/$ac_aux_dir/missing,
# iff we strip the leading $srcdir from $ac_aux_dir.  That would be:
#   am_aux_dir='\$(top_srcdir)/'`expr "$ac_aux_dir" : "$srcdir//*\(.*\)"`
# and then we would define $MISSING as
#   MISSING="\${SHELL} $am_aux_dir/missing"
# This will work as long as MISSING is not called from configure, because
# unfortunately $(top_srcdir) has no meaning in configure.
# However there are other variables, like CC, which are often used in
# configure, and could therefore not use this "fixed" $ac_aux_dir.
#
# Another solution, used here, is to always expand $ac_aux_dir to an
# absolute PATH.  The drawback is that using absolute paths prevent a
# configured tree to be moved without reconfiguration.

# Rely on autoconf to set up CDPATH properly.
AC_PREREQ([2.50])

AC_DEFUN([AM_AUX_DIR_EXPAND], [
# expand $ac_aux_dir to an absolute path
am_aux_dir=`cd $ac_aux_dir && pwd`
])

# AM_PROG_INSTALL_SH
# ------------------
# Define $install_sh.

# Copyright 2001 Free Software Foundation, Inc.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.

AC_DEFUN([AM_PROG_INSTALL_SH],
[AC_REQUIRE([AM_AUX_DIR_EXPAND])dnl
install_sh=${install_sh-"$am_aux_dir/install-sh"}
AC_SUBST(install_sh)])

# AM_PROG_INSTALL_STRIP

# Copyright 2001 Free Software Foundation, Inc.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.

# One issue with vendor `install' (even GNU) is that you can't
# specify the program used to strip binaries.  This is especially
# annoying in cross-compiling environments, where the build's strip
# is unlikely to handle the host's binaries.
# Fortunately install-sh will honor a STRIPPROG variable, so we
# always use install-sh in `make install-strip', and initialize
# STRIPPROG with the value of the STRIP variable (set by the user).
AC_DEFUN([AM_PROG_INSTALL_STRIP],
[AC_REQUIRE([AM_PROG_INSTALL_SH])dnl
# Installed binaries are usually stripped using `strip' when the user
# run `make install-strip'.  However `strip' might not be the right
# tool to use in cross-compilation environments, therefore Automake
# will honor the `STRIP' environment variable to overrule this program.
dnl Don't test for $cross_compiling = yes, because it might be `maybe'.
if test "$cross_compiling" != no; then
  AC_CHECK_TOOL([STRIP], [strip], :)
fi
INSTALL_STRIP_PROGRAM="\${SHELL} \$(install_sh) -c -s"
AC_SUBST([INSTALL_STRIP_PROGRAM])])

#                                                          -*- Autoconf -*-
# Copyright (C) 2003  Free Software Foundation, Inc.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.

# serial 1

# Check whether the underlying file-system supports filenames
# with a leading dot.  For instance MS-DOS doesn't.
AC_DEFUN([AM_SET_LEADING_DOT],
[rm -rf .tst 2>/dev/null
mkdir .tst 2>/dev/null
if test -d .tst; then
  am__leading_dot=.
else
  am__leading_dot=_
fi
rmdir .tst 2>/dev/null
AC_SUBST([am__leading_dot])])

# serial 5						-*- Autoconf -*-

# Copyright (C) 1999, 2000, 2001, 2002, 2003  Free Software Foundation, Inc.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.


# There are a few dirty hacks below to avoid letting `AC_PROG_CC' be
# written in clear, in which case automake, when reading aclocal.m4,
# will think it sees a *use*, and therefore will trigger all it's
# C support machinery.  Also note that it means that autoscan, seeing
# CC etc. in the Makefile, will ask for an AC_PROG_CC use...



# _AM_DEPENDENCIES(NAME)
# ----------------------
# See how the compiler implements dependency checking.
# NAME is "CC", "CXX", "GCJ", or "OBJC".
# We try a few techniques and use that to set a single cache variable.
#
# We don't AC_REQUIRE the corresponding AC_PROG_CC since the latter was
# modified to invoke _AM_DEPENDENCIES(CC); we would have a circular
# dependency, and given that the user is not expected to run this macro,
# just rely on AC_PROG_CC.
AC_DEFUN([_AM_DEPENDENCIES],
[AC_REQUIRE([AM_SET_DEPDIR])dnl
AC_REQUIRE([AM_OUTPUT_DEPENDENCY_COMMANDS])dnl
AC_REQUIRE([AM_MAKE_INCLUDE])dnl
AC_REQUIRE([AM_DEP_TRACK])dnl

ifelse([$1], CC,   [depcc="$CC"   am_compiler_list=],
       [$1], CXX,  [depcc="$CXX"  am_compiler_list=],
       [$1], OBJC, [depcc="$OBJC" am_compiler_list='gcc3 gcc'],
       [$1], GCJ,  [depcc="$GCJ"  am_compiler_list='gcc3 gcc'],
                   [depcc="$$1"   am_compiler_list=])

AC_CACHE_CHECK([dependency style of $depcc],
               [am_cv_$1_dependencies_compiler_type],
[if test -z "$AMDEP_TRUE" && test -f "$am_depcomp"; then
  # We make a subdir and do the tests there.  Otherwise we can end up
  # making bogus files that we don't know about and never remove.  For
  # instance it was reported that on HP-UX the gcc test will end up
  # making a dummy file named `D' -- because `-MD' means `put the output
  # in D'.
  mkdir conftest.dir
  # Copy depcomp to subdir because otherwise we won't find it if we're
  # using a relative directory.
  cp "$am_depcomp" conftest.dir
  cd conftest.dir
  # We will build objects and dependencies in a subdirectory because
  # it helps to detect inapplicable dependency modes.  For instance
  # both Tru64's cc and ICC support -MD to output dependencies as a
  # side effect of compilation, but ICC will put the dependencies in
  # the current directory while Tru64 will put them in the object
  # directory.
  mkdir sub

  am_cv_$1_dependencies_compiler_type=none
  if test "$am_compiler_list" = ""; then
     am_compiler_list=`sed -n ['s/^#*\([a-zA-Z0-9]*\))$/\1/p'] < ./depcomp`
  fi
  for depmode in $am_compiler_list; do
    # Setup a source with many dependencies, because some compilers
    # like to wrap large dependency lists on column 80 (with \), and
    # we should not choose a depcomp mode which is confused by this.
    #
    # We need to recreate these files for each test, as the compiler may
    # overwrite some of them when testing with obscure command lines.
    # This happens at least with the AIX C compiler.
    : > sub/conftest.c
    for i in 1 2 3 4 5 6; do
      echo '#include "conftst'$i'.h"' >> sub/conftest.c
      : > sub/conftst$i.h
    done
    echo "${am__include} ${am__quote}sub/conftest.Po${am__quote}" > confmf

    case $depmode in
    nosideeffect)
      # after this tag, mechanisms are not by side-effect, so they'll
      # only be used when explicitly requested
      if test "x$enable_dependency_tracking" = xyes; then
	continue
      else
	break
      fi
      ;;
    none) break ;;
    esac
    # We check with `-c' and `-o' for the sake of the "dashmstdout"
    # mode.  It turns out that the SunPro C++ compiler does not properly
    # handle `-M -o', and we need to detect this.
    if depmode=$depmode \
       source=sub/conftest.c object=sub/conftest.${OBJEXT-o} \
       depfile=sub/conftest.Po tmpdepfile=sub/conftest.TPo \
       $SHELL ./depcomp $depcc -c -o sub/conftest.${OBJEXT-o} sub/conftest.c \
         >/dev/null 2>conftest.err &&
       grep sub/conftst6.h sub/conftest.Po > /dev/null 2>&1 &&
       grep sub/conftest.${OBJEXT-o} sub/conftest.Po > /dev/null 2>&1 &&
       ${MAKE-make} -s -f confmf > /dev/null 2>&1; then
      # icc doesn't choke on unknown options, it will just issue warnings
      # (even with -Werror).  So we grep stderr for any message
      # that says an option was ignored.
      if grep 'ignoring option' conftest.err >/dev/null 2>&1; then :; else
        am_cv_$1_dependencies_compiler_type=$depmode
        break
      fi
    fi
  done

  cd ..
  rm -rf conftest.dir
else
  am_cv_$1_dependencies_compiler_type=none
fi
])
AC_SUBST([$1DEPMODE], [depmode=$am_cv_$1_dependencies_compiler_type])
AM_CONDITIONAL([am__fastdep$1], [
  test "x$enable_dependency_tracking" != xno \
  && test "$am_cv_$1_dependencies_compiler_type" = gcc3])
])


# AM_SET_DEPDIR
# -------------
# Choose a directory name for dependency files.
# This macro is AC_REQUIREd in _AM_DEPENDENCIES
AC_DEFUN([AM_SET_DEPDIR],
[AC_REQUIRE([AM_SET_LEADING_DOT])dnl
AC_SUBST([DEPDIR], ["${am__leading_dot}deps"])dnl
])


# AM_DEP_TRACK
# ------------
AC_DEFUN([AM_DEP_TRACK],
[AC_ARG_ENABLE(dependency-tracking,
[  --disable-dependency-tracking Speeds up one-time builds
  --enable-dependency-tracking  Do not reject slow dependency extractors])
if test "x$enable_dependency_tracking" != xno; then
  am_depcomp="$ac_aux_dir/depcomp"
  AMDEPBACKSLASH='\'
fi
AM_CONDITIONAL([AMDEP], [test "x$enable_dependency_tracking" != xno])
AC_SUBST([AMDEPBACKSLASH])
])

# Generate code to set up dependency tracking.   -*- Autoconf -*-

# Copyright 1999, 2000, 2001, 2002 Free Software Foundation, Inc.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.

#serial 2

# _AM_OUTPUT_DEPENDENCY_COMMANDS
# ------------------------------
AC_DEFUN([_AM_OUTPUT_DEPENDENCY_COMMANDS],
[for mf in $CONFIG_FILES; do
  # Strip MF so we end up with the name of the file.
  mf=`echo "$mf" | sed -e 's/:.*$//'`
  # Check whether this is an Automake generated Makefile or not.
  # We used to match only the files named `Makefile.in', but
  # some people rename them; so instead we look at the file content.
  # Grep'ing the first line is not enough: some people post-process
  # each Makefile.in and add a new line on top of each file to say so.
  # So let's grep whole file.
  if grep '^#.*generated by automake' $mf > /dev/null 2>&1; then
    dirpart=`AS_DIRNAME("$mf")`
  else
    continue
  fi
  grep '^DEP_FILES *= *[[^ @%:@]]' < "$mf" > /dev/null || continue
  # Extract the definition of DEP_FILES from the Makefile without
  # running `make'.
  DEPDIR=`sed -n -e '/^DEPDIR = / s///p' < "$mf"`
  test -z "$DEPDIR" && continue
  # When using ansi2knr, U may be empty or an underscore; expand it
  U=`sed -n -e '/^U = / s///p' < "$mf"`
  test -d "$dirpart/$DEPDIR" || mkdir "$dirpart/$DEPDIR"
  # We invoke sed twice because it is the simplest approach to
  # changing $(DEPDIR) to its actual value in the expansion.
  for file in `sed -n -e '
    /^DEP_FILES = .*\\\\$/ {
      s/^DEP_FILES = //
      :loop
	s/\\\\$//
	p
	n
	/\\\\$/ b loop
      p
    }
    /^DEP_FILES = / s/^DEP_FILES = //p' < "$mf" | \
       sed -e 's/\$(DEPDIR)/'"$DEPDIR"'/g' -e 's/\$U/'"$U"'/g'`; do
    # Make sure the directory exists.
    test -f "$dirpart/$file" && continue
    fdir=`AS_DIRNAME(["$file"])`
    AS_MKDIR_P([$dirpart/$fdir])
    # echo "creating $dirpart/$file"
    echo '# dummy' > "$dirpart/$file"
  done
done
])# _AM_OUTPUT_DEPENDENCY_COMMANDS


# AM_OUTPUT_DEPENDENCY_COMMANDS
# -----------------------------
# This macro should only be invoked once -- use via AC_REQUIRE.
#
# This code is only required when automatic dependency tracking
# is enabled.  FIXME.  This creates each `.P' file that we will
# need in order to bootstrap the dependency handling code.
AC_DEFUN([AM_OUTPUT_DEPENDENCY_COMMANDS],
[AC_CONFIG_COMMANDS([depfiles],
     [test x"$AMDEP_TRUE" != x"" || _AM_OUTPUT_DEPENDENCY_COMMANDS],
     [AMDEP_TRUE="$AMDEP_TRUE" ac_aux_dir="$ac_aux_dir"])
])

# Check to see how 'make' treats includes.	-*- Autoconf -*-

# Copyright (C) 2001, 2002, 2003 Free Software Foundation, Inc.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.

# serial 2

# AM_MAKE_INCLUDE()
# -----------------
# Check to see how make treats includes.
AC_DEFUN([AM_MAKE_INCLUDE],
[am_make=${MAKE-make}
cat > confinc << 'END'
am__doit:
	@echo done
.PHONY: am__doit
END
# If we don't find an include directive, just comment out the code.
AC_MSG_CHECKING([for style of include used by $am_make])
am__include="#"
am__quote=
_am_result=none
# First try GNU make style include.
echo "include confinc" > confmf
# We grep out `Entering directory' and `Leaving directory'
# messages which can occur if `w' ends up in MAKEFLAGS.
# In particular we don't look at `^make:' because GNU make might
# be invoked under some other name (usually "gmake"), in which
# case it prints its new name instead of `make'.
if test "`$am_make -s -f confmf 2> /dev/null | grep -v 'ing directory'`" = "done"; then
   am__include=include
   am__quote=
   _am_result=GNU
fi
# Now try BSD make style include.
if test "$am__include" = "#"; then
   echo '.include "confinc"' > confmf
   if test "`$am_make -s -f confmf 2> /dev/null`" = "done"; then
      am__include=.include
      am__quote="\""
      _am_result=BSD
   fi
fi
AC_SUBST([am__include])
AC_SUBST([am__quote])
AC_MSG_RESULT([$_am_result])
rm -f confinc confmf
])

# AM_CONDITIONAL                                              -*- Autoconf -*-

# Copyright 1997, 2000, 2001 Free Software Foundation, Inc.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.

# serial 5

AC_PREREQ(2.52)

# AM_CONDITIONAL(NAME, SHELL-CONDITION)
# -------------------------------------
# Define a conditional.
AC_DEFUN([AM_CONDITIONAL],
[ifelse([$1], [TRUE],  [AC_FATAL([$0: invalid condition: $1])],
        [$1], [FALSE], [AC_FATAL([$0: invalid condition: $1])])dnl
AC_SUBST([$1_TRUE])
AC_SUBST([$1_FALSE])
if $2; then
  $1_TRUE=
  $1_FALSE='#'
else
  $1_TRUE='#'
  $1_FALSE=
fi
AC_CONFIG_COMMANDS_PRE(
[if test -z "${$1_TRUE}" && test -z "${$1_FALSE}"; then
  AC_MSG_ERROR([conditional "$1" was never defined.
Usually this means the macro was only invoked conditionally.])
fi])])

# Like AC_CONFIG_HEADER, but automatically create stamp file. -*- Autoconf -*-

# Copyright 1996, 1997, 2000, 2001 Free Software Foundation, Inc.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.

AC_PREREQ([2.52])

# serial 6

# AM_CONFIG_HEADER is obsolete.  It has been replaced by AC_CONFIG_HEADERS.
AU_DEFUN([AM_CONFIG_HEADER], [AC_CONFIG_HEADERS($@)])

